/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnNeIDAndVrID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnLDPTunnelGroupInfoList;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnNeIDResult;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTunnelReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTunnelRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpLsp;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnLDPTunnelGroupInfoTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnRSVPTunnelInfoTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnStaticCRTunnelInfoTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QueryTunnelTask
extends AbstractQTask<QAsnQueryTunnelReq, QAsnQueryTunnelRsp> {
    protected void executeTask(QAsnQueryTunnelReq req, QAsnQueryTunnelRsp rsp, Task task) {
        QAsnNeIDResult neRet;
        ArrayList<Integer> devIdList = new ArrayList<Integer>(req.lstNeIDAndVrID.size());
        for (Object neIDAndVrIDObj : req.lstNeIDAndVrID) {
            QAsnNeIDAndVrID neIDAndVrID = (QAsnNeIDAndVrID)neIDAndVrIDObj;
            devIdList.add(neIDAndVrID.iNeID);
            neRet = new QAsnNeIDResult();
            neRet.oNeID = neIDAndVrID.iNeID;
            neRet.oResult.errCode = 0;
            rsp.lstFail.add((Object)neRet);
        }
        this.getLogger().info("query tunnel by devid " + devIdList);
        try {
            rsp.oResult.result = 0;
            if (!MplsUtil.isPtn()) {
                this.queryRsvpTeTunnel(devIdList, rsp);
            }
            if (!MplsUtil.isPtn()) {
                this.queryLdpLspTunnel(devIdList, rsp);
            }
            if (MplsUtil.isPtn()) {
                this.queryStaticCRTunnel(devIdList, rsp);
            }
        }
        catch (VMFException e) {
            rsp.oResult.result = e.getErrorCode();
            for (Object obj : rsp.lstFail) {
                neRet = (QAsnNeIDResult)obj;
                neRet.oResult.errCode = e.getErrorCode();
                neRet.oResult.strOperDesc = StringUtil.globalByte((String)e.getErrorMessage());
            }
            this.getLogger().error("QueryTunnelTask query failed", (Throwable)e);
        }
    }

    private void queryLdpLspTunnel(List<Integer> devIdList, QAsnQueryTunnelRsp rsp) throws VMFException {
        ArrayList<LdpLsp> ldpLspList = new ArrayList<LdpLsp>();
        MplsDevDao devDao = MplsDevDao.newInstance();
        Iterator<Integer> i$ = devIdList.iterator();
        while (i$.hasNext()) {
            Integer obj;
            Integer devID = obj = i$.next();
            ldpLspList.addAll(devDao.queryLdpLsp(devID));
        }
        if (CollectionUtils.isEmpty(ldpLspList)) {
            return;
        }
        QAsnLDPTunnelGroupInfoTranslator ldpTranslator = new QAsnLDPTunnelGroupInfoTranslator();
        Collection ldpTunnelGroupInfoList = ldpTranslator.encode(ldpLspList, null);
        rsp.lstLDPTnlGroupInfo = new QAsnLDPTunnelGroupInfoList();
        rsp.lstLDPTnlGroupInfo.addAll(ldpTunnelGroupInfoList);
    }

    private void queryRsvpTeTunnel(List<Integer> devIdList, QAsnQueryTunnelRsp rsp) throws VMFException {
        MplsDao dao = MplsDao.newInstance();
        Collection tunnels = dao.queryByNeID(RsvpTeTunnel.class, devIdList, true);
        dao.loadTunnelIfAndKeyRef(tunnels, true);
        QAsnRSVPTunnelInfoTranslator tunnelTranslator = new QAsnRSVPTunnelInfoTranslator();
        if (!CollectionUtils.isEmpty((Collection)tunnels)) {
            Collection rsvpTunnelInfoList = tunnelTranslator.encode(tunnels, (IAsnTranslationContext)new AsnTranslationContext());
            rsp.lstRsvpTunnelInfo.addAll(rsvpTunnelInfoList);
        }
    }

    private void queryStaticCRTunnel(List<Integer> devIdList, QAsnQueryTunnelRsp rsp) throws VMFException {
        MplsDao dao = MplsDao.newInstance();
        Collection tunnels = dao.queryByNeID(StaticTunnel.class, devIdList, true);
        dao.loadStaticTunnelInterfaceByName(tunnels, true);
        QAsnStaticCRTunnelInfoTranslator translator = new QAsnStaticCRTunnelInfoTranslator();
        if (!CollectionUtils.isEmpty((Collection)tunnels)) {
            Collection rsvpTunnelInfoList = translator.encode(tunnels, (IAsnTranslationContext)new AsnTranslationContext());
            rsp.lstStaticCRTunnelInfo.addAll(rsvpTunnelInfoList);
        }
    }
}

