/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyInfoResult;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTunnelKeyFDNReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTunnelKeyFDNRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelKeyInfoResultTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelKeyInfoTranslator;
import java.util.ArrayList;
import net.commustru.fstru.FStruct;

public class QueryTunnelKeyFDNTask
extends AbstractQTask<QAsnQueryTunnelKeyFDNReq, QAsnQueryTunnelKeyFDNRsp> {
    protected void executeTask(QAsnQueryTunnelKeyFDNReq req, QAsnQueryTunnelKeyFDNRsp rsp, Task task) {
        QAsnTunnelKeyInfoTranslator decodeTranslator = new QAsnTunnelKeyInfoTranslator();
        QAsnTunnelKeyInfoResultTranslator encodeTranslator = new QAsnTunnelKeyInfoResultTranslator();
        AsnTranslationContext asnTranslationContext = new AsnTranslationContext();
        Context ctx = new Context();
        asnTranslationContext.setTransactionContext(ctx);
        OperResult operResult = ctx.getOperResult();
        ArrayList<RsvpTeTunnel> tunnels = new ArrayList<RsvpTeTunnel>();
        try {
            for (Object tunnelKeyInfoObj : req.lstTunnelKeyInfo) {
                QAsnTunnelKeyInfo qasnTunnelKeyInfo = (QAsnTunnelKeyInfo)tunnelKeyInfoObj;
                RsvpTeTunnel tunnel = (RsvpTeTunnel)decodeTranslator.decode((FStruct)qasnTunnelKeyInfo, (IAsnTranslationContext)asnTranslationContext);
                tunnels.add(tunnel);
                QAsnTunnelKeyInfoResult asn = (QAsnTunnelKeyInfoResult)encodeTranslator.encode(tunnel, (IAsnTranslationContext)asnTranslationContext);
                String fdn = StringUtil.globalString((byte[])asn.oTunnelKeyInfo.oTunnelKey.strFDN);
                if (StringUtil.isEmpty((String)fdn)) {
                    AsnTranslatorUtil.addMoOperResult((VmfMO)tunnel, (Context)ctx, (int)1107499878);
                }
                asn.poOperResult = AsnTranslatorUtil.getMoQAsnSingleReturn((VmfMO)tunnel, (OperResult)operResult);
                rsp.lstTunnelKeyInfo.add((Object)asn);
            }
            rsp.oReturn = AsnTranslatorUtil.getMosQAsnErrInfoReturn(tunnels, (OperResult)operResult);
        }
        catch (VMFException e) {
            rsp.oReturn.result = 1107499878;
        }
    }
}

