/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelIdentifier;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelOnPort;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTunnelInfoByPortReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTunnelInfoByPortRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeLsp;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelIdentifierTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class QueryTunnelInfoByPortTask
extends AbstractQTask<QAsnQueryTunnelInfoByPortReq, QAsnQueryTunnelInfoByPortRsp> {
    private static Logger LOGGER = LoggerFactory.getLogger(QueryTunnelInfoByPortTask.class);
    private QAsnTunnelIdentifierTranslator asnTranslator = new QAsnTunnelIdentifierTranslator();
    private InterfaceFdnParser fdnParser = new InterfaceFdnParser();

    protected void executeTask(QAsnQueryTunnelInfoByPortReq req, QAsnQueryTunnelInfoByPortRsp rsp, Task task) {
        ArrayList<String> queryAttrNames = new ArrayList<String>();
        queryAttrNames.add("devID");
        queryAttrNames.add("vrID");
        queryAttrNames.add("mplsTunnelEgressLSRId");
        queryAttrNames.add("mplsTunnelIngressLSRId");
        queryAttrNames.add("mplsSessionID");
        queryAttrNames.add("mplsTunnelInstance");
        queryAttrNames.add("tunnelName");
        queryAttrNames.add("iTransportType");
        queryAttrNames.add("iSignalType");
        queryAttrNames.add("mplsTunnelRole");
        HashMap interfaceAndRsvpTeLspsMap = new HashMap();
        for (Object objFdn : req.lstPortFdn) {
            if (!(objFdn instanceof QAsnUniResID)) continue;
            QAsnUniResID fdn = (QAsnUniResID)objFdn;
            String objType = StringUtil.globalString((byte[])fdn.strMOC);
            if (ObjectUtils.equals((Object)"NE", (Object)objType)) {
                RsvpTeLsp rsvpTeLspCondition = new RsvpTeLsp();
                rsvpTeLspCondition.setDevID(Integer.valueOf(fdn.neID));
                QAsnTunnelOnPort tunnels = new QAsnTunnelOnPort();
                tunnels.oPort = fdn;
                tunnels.lstTnlIdentifier.addAll(this.convertTnlIdentifiers(this.pollRsvpTeLsp(rsvpTeLspCondition, queryAttrNames)));
                rsp.lstTnlOnPort.add((Object)tunnels);
                continue;
            }
            Interface iInterface = (Interface)this.fdnParser.getIndexMo((QAsnUniResID)objFdn);
            if (iInterface.getIfName() == null) continue;
            HashSet<RsvpTeLsp> rsvpTeLsps = (HashSet<RsvpTeLsp>)interfaceAndRsvpTeLspsMap.get(iInterface);
            if (null == rsvpTeLsps) {
                rsvpTeLsps = new HashSet<RsvpTeLsp>();
                interfaceAndRsvpTeLspsMap.put(iInterface, rsvpTeLsps);
            }
            RsvpTeLsp rsvpTeLspCondition = new RsvpTeLsp();
            rsvpTeLspCondition.setDevID(iInterface.getDevID());
            rsvpTeLspCondition.setVrID(iInterface.getVrID());
            rsvpTeLspCondition.setIncomingIfName(iInterface.getIfName());
            rsvpTeLsps.addAll(this.pollRsvpTeLsp(rsvpTeLspCondition, queryAttrNames));
            rsvpTeLspCondition = new RsvpTeLsp();
            rsvpTeLspCondition.setDevID(iInterface.getDevID());
            rsvpTeLspCondition.setVrID(iInterface.getVrID());
            rsvpTeLspCondition.setOutgoingIfName(iInterface.getIfName());
            rsvpTeLsps.addAll(this.pollRsvpTeLsp(rsvpTeLspCondition, queryAttrNames));
        }
        rsp.oReturn.result = 0;
        rsp.lstTnlOnPort.clear();
        if (CollectionUtils.isEmpty(interfaceAndRsvpTeLspsMap)) {
            return;
        }
        for (Map.Entry interfaceAndRsvpTeLsps : interfaceAndRsvpTeLspsMap.entrySet()) {
            QAsnTunnelOnPort tunnelOnPort = new QAsnTunnelOnPort();
            tunnelOnPort.result.errCode = 0;
            tunnelOnPort.oPort = this.fdnParser.getUniResID((VmfMO)interfaceAndRsvpTeLsps.getKey());
            tunnelOnPort.lstTnlIdentifier.addAll(this.convertTnlIdentifiers((Collection)interfaceAndRsvpTeLsps.getValue()));
            rsp.lstTnlOnPort.add((Object)tunnelOnPort);
        }
        LOGGER.info("rsp is " + rsp);
    }

    private Collection<QAsnTunnelIdentifier> convertTnlIdentifiers(Collection<RsvpTeLsp> rsvpTeLsps) {
        if (CollectionUtils.isEmpty(rsvpTeLsps)) {
            return Collections.emptySet();
        }
        ArrayList<QAsnTunnelIdentifier> tunnelIdentifiers = new ArrayList<QAsnTunnelIdentifier>();
        for (RsvpTeLsp rsvpTeLsp : rsvpTeLsps) {
            QAsnTunnelIdentifier tunnelIdentifier = new QAsnTunnelIdentifier();
            try {
                this.asnTranslator.encode(rsvpTeLsp, tunnelIdentifier, (IAsnTranslationContext)new AsnTranslationContext());
            }
            catch (VMFException e) {
                LOGGER.error("query error0.", (Throwable)e);
                continue;
            }
            tunnelIdentifier.iSignalType = 4;
            tunnelIdentifier.iTransportType = 1;
            tunnelIdentifiers.add(tunnelIdentifier);
        }
        return tunnelIdentifiers;
    }

    private Collection<RsvpTeLsp> pollRsvpTeLsp(RsvpTeLsp rsvpTeLspCondition, Collection<String> queryAttrNames) {
        DefaultMOService moService = new DefaultMOService();
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(rsvpTeLspCondition.getDevID().intValue());
        queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)rsvpTeLspCondition, queryAttrNames);
        moService.addQueryJob(queryContext);
        try {
            moService.poll();
        }
        catch (VMFException e) {
            LOGGER.error("query error1.", (Throwable)e);
            return Collections.emptySet();
        }
        return moService.getQueryContext(rsvpTeLspCondition.getDevID().intValue()).getQueryResult(RsvpTeLsp.class);
    }
}

