/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTunnelISUsedReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTunnelISUsedRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsPw;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsSwitchPw;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsLdpPw;
import com.huawei.vmf.adapter.mpls.common.MplsAsnUtil;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QueryTunnelISUsedTask
extends AbstractQTask<QAsnQueryTunnelISUsedReq, QAsnQueryTunnelISUsedRsp> {
    protected void executeTask(QAsnQueryTunnelISUsedReq req, QAsnQueryTunnelISUsedRsp rsp, Task task) {
        ArrayList<StaticTunnel> staticFdnTunnels = new ArrayList<StaticTunnel>();
        ArrayList<RsvpTeTunnel> rsvpTeFdnTunnels = new ArrayList<RsvpTeTunnel>();
        MplsAsnUtil.parseTunnelKeys(req.lstTunnelKey, rsvpTeFdnTunnels, staticFdnTunnels);
        try {
            this.dealRsvpTeTunnel(rsvpTeFdnTunnels, rsp);
            this.dealStaticCRTunnel(staticFdnTunnels, rsp);
            rsp.oResult.result = 0;
        }
        catch (VMFException e) {
            this.getLogger().error("QueryTunnelISUsed failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
        }
    }

    private void dealStaticCRTunnel(List<StaticTunnel> staticFdnTunnels, QAsnQueryTunnelISUsedRsp rsp) {
        IFdnParser<StaticTunnel> staticTunnelParser = MplsUtil.getStaticTunnelFdnParser();
        for (StaticTunnel staticTunnel : staticFdnTunnels) {
            rsp.lstSucTunnelKey.add((Object)staticTunnelParser.getUniResID((VmfMO)staticTunnel));
        }
    }

    private void dealRsvpTeTunnel(List<RsvpTeTunnel> rsvpTeFdnTunnels, QAsnQueryTunnelISUsedRsp rsp) throws VMFException {
        QAsnUniResID resId;
        RsvpTeTunnel tunnel2;
        RsvpTeTunnelFdnParser rsvpTeTunnelParser = new RsvpTeTunnelFdnParser();
        MplsDao dao = MplsDao.newInstance();
        Collection tunnels = dao.queryByKey(RsvpTeTunnel.class, rsvpTeFdnTunnels, false);
        Iterator iter = tunnels.iterator();
        while (iter.hasNext()) {
            tunnel2 = (RsvpTeTunnel)iter.next();
            if (!this.isUsedByProtection(tunnel2)) continue;
            resId = rsvpTeTunnelParser.getUniResID((VmfMO)tunnel2);
            rsp.lstFailTunnelKey.add((Object)resId);
            iter.remove();
        }
        iter = tunnels.iterator();
        while (iter.hasNext()) {
            tunnel2 = (RsvpTeTunnel)iter.next();
            if (tunnel2.isDeployed()) continue;
            resId = rsvpTeTunnelParser.getUniResID((VmfMO)tunnel2);
            rsp.lstSucTunnelKey.add((Object)resId);
            iter.remove();
        }
        MplsDevDao.newInstance().loadTunnelVPN(tunnels, 0);
        for (RsvpTeTunnel tunnel2 : tunnels) {
            resId = rsvpTeTunnelParser.getUniResID((VmfMO)tunnel2);
            if (this.isUsedByVpn(tunnel2)) {
                rsp.lstFailTunnelKey.add((Object)resId);
                continue;
            }
            rsp.lstSucTunnelKey.add((Object)resId);
        }
    }

    private boolean isUsedByProtection(RsvpTeTunnel tunnel) throws VMFException {
        return false;
    }

    private boolean isUsedByVpn(RsvpTeTunnel tunnel) throws VMFException {
        List vrfs = tunnel.getKeyRefMos(L3vpnInstance.class);
        List vplsLdpPws = tunnel.getKeyRefMos(VplsLdpPw.class);
        List vpwsPws = tunnel.getKeyRefMos(VpwsPw.class);
        List vpwsSwitchPws = tunnel.getKeyRefMos(VpwsSwitchPw.class);
        return !CollectionUtils.isEmpty((Collection)vrfs) || !CollectionUtils.isEmpty((Collection)vplsLdpPws) || !CollectionUtils.isEmpty((Collection)vpwsPws) || !CollectionUtils.isEmpty((Collection)vpwsSwitchPws);
    }
}

