/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnUniResIDAndName;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnUniResIDAndNameList;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTunnelFDNByNameReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTunnelFDNByNameRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnUniResIDAndNameTranslator;
import java.util.ArrayList;
import java.util.Collection;

public class QueryTunnelFDNByNameTask
extends AbstractQTask<QAsnQueryTunnelFDNByNameReq, QAsnQueryTunnelFDNByNameRsp> {
    protected void executeTask(QAsnQueryTunnelFDNByNameReq req, QAsnQueryTunnelFDNByNameRsp rsp, Task task) {
        ArrayList<Integer> devIdList = new ArrayList<Integer>();
        devIdList.add(req.neID);
        ArrayList<RsvpTeTunnel> tunnelList = new ArrayList<RsvpTeTunnel>();
        for (Object str : req.nameList) {
            String tunnelName = new String((byte[])str);
            RsvpTeTunnel tunnel = new RsvpTeTunnel();
            tunnel.setTunnelName(tunnelName);
            tunnelList.add(tunnel);
        }
        rsp.resIDAndNameList = this.queryTunnelByDevIdAndNameList(devIdList, new String[]{"tunnelName"}, tunnelList, rsp.result);
    }

    private QAsnUniResIDAndNameList queryTunnelByDevIdAndNameList(Collection<Integer> devIdList, String[] fieldNames, Collection<RsvpTeTunnel> conditions, QAsnErrInfoReturn result) {
        MplsDao dao = MplsDao.newInstance();
        QAsnUniResIDAndNameList resIDAndNameList = new QAsnUniResIDAndNameList();
        result.result = 0;
        try {
            Collection tunnels = dao.queryByNeID(RsvpTeTunnel.class, devIdList, fieldNames, conditions, true);
            QAsnUniResIDAndNameTranslator translator = new QAsnUniResIDAndNameTranslator();
            for (RsvpTeTunnel mo : tunnels) {
                QAsnUniResIDAndName asnUniResIDAndName = new QAsnUniResIDAndName();
                try {
                    translator.encode(mo, asnUniResIDAndName, null);
                }
                catch (VMFException e) {
                    result.result = e.getErrorCode();
                    this.getLogger().error("DeleteTunnleTask encode exception.", (Throwable)e);
                }
                resIDAndNameList.add((Object)asnUniResIDAndName);
            }
        }
        catch (VMFException e) {
            result.result = e.getErrorCode();
            this.getLogger().error("queryTunnelByDevIdAndNameList failed!", (Throwable)e);
            return null;
        }
        return resIDAndNameList;
    }
}

