/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTnlRunStatusFromNEReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTnlRunStatusFromNERsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.mpls.common.MplsAsnUtil;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelRunStatusInfoTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class QueryTnlRunStatusFromNETask
extends AbstractQTask<QAsnQueryTnlRunStatusFromNEReq, QAsnQueryTnlRunStatusFromNERsp> {
    protected void executeTask(QAsnQueryTnlRunStatusFromNEReq req, QAsnQueryTnlRunStatusFromNERsp rsp, Task task) {
        ArrayList<RsvpTeTunnel> rsvpTeFdnTunnels = new ArrayList<RsvpTeTunnel>();
        ArrayList<StaticTunnel> staticFdnTunnels = new ArrayList<StaticTunnel>();
        MplsAsnUtil.parseTunnelKeys(req.lstTunnelKey, rsvpTeFdnTunnels, staticFdnTunnels);
        HashMap<VmfMO, ErrorInfo> moResults = new HashMap<VmfMO, ErrorInfo>();
        try {
            MplsDevDao.newInstance().syncTunnelStatus(rsvpTeFdnTunnels, moResults);
        }
        catch (VMFException e) {
            this.getLogger().error("QueryTnlRunStatusFromNETask syncTunnelStatus failed!", (Throwable)e);
            rsp.oResult.result = e.getErrorCode();
            return;
        }
        this.saveState(rsvpTeFdnTunnels, moResults);
        QAsnTunnelRunStatusInfoTranslator translator = new QAsnTunnelRunStatusInfoTranslator();
        AsnTranslationContext context = new AsnTranslationContext();
        context.setTransactionContext(new Context());
        context.getTransactionContext().addMoOperResults(moResults);
        try {
            Collection asns = translator.encode(rsvpTeFdnTunnels, (IAsnTranslationContext)context);
            rsp.lstTunnelStatusInfo.addAll(asns);
            rsp.oResult.result = context.getTransactionContext().getTotalErrorCode(rsvpTeFdnTunnels);
        }
        catch (VMFException e) {
            this.getLogger().error("QueryTnlRunStatusFromNETask encode failed!", (Throwable)e);
            rsp.oResult.result = e.getErrorCode();
        }
    }

    private void saveState(Collection<RsvpTeTunnel> mos, Map<VmfMO, ErrorInfo> moResults) {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        Context ctx = new Context();
        IMOChangeRecord record = ctx.addChangeRecord(RsvpTeTunnel.class);
        List<String> fieldNames = Arrays.asList("operStatus", "adminStatus");
        for (RsvpTeTunnel mo : mos) {
            ErrorInfo err = MplsUtil.getMOOperResult((VmfMO)mo, moResults);
            if (err.getErrorCode() != 0) {
                this.getLogger().error("sync revp tunnel status fialed, tunnel = {}, error = {}", (Object)mo, (Object)err);
                continue;
            }
            record.addModify((Object)mo, fieldNames);
        }
        try {
            MplsDao.newInstance(ctx).merge(false, new Class[]{RsvpTeTunnel.class});
        }
        catch (VMFException e) {
            this.getLogger().error("QueryTnlRunStatusFromNETask saveState failed!", (Throwable)e);
        }
    }
}

