/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelPGStatus;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTnlPGStatusReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryTnlPGStatusRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.TunnelGroupFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelGroup;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.slf4j.Logger;

public class QueryTnlPGStatusTask
extends AbstractQTask<QAsnQueryTnlPGStatusReq, QAsnQueryTnlPGStatusRsp> {
    private Logger logger = RunLogger.getLogger(QueryTnlPGStatusTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask(QAsnQueryTnlPGStatusReq req, QAsnQueryTnlPGStatusRsp rsp, Task task) {
        DefaultMOService pollService = new DefaultMOService();
        Context context = new Context();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(context);
        IMOChangeRecord record = context.addChangeRecord(TunnelGroup.class);
        LinkedList<TunnelGroup> tunnelGroupKeys = new LinkedList<TunnelGroup>();
        HashMap<TunnelGroup, QAsnUniResID> tgpKeyToFdnAsnMap = new HashMap<TunnelGroup, QAsnUniResID>();
        TunnelGroupFdnParser fdnParser = new TunnelGroupFdnParser();
        for (QAsnUniResID fdnAsn : req.lstProtectionGroupKey) {
            TunnelGroup tunnelGroup = (TunnelGroup)fdnParser.getIndexMo(fdnAsn);
            tunnelGroupKeys.add(tunnelGroup);
            tgpKeyToFdnAsnMap.put(tunnelGroup, fdnAsn);
        }
        try {
            Collection tunnelGroupResults = dao.queryByKey(TunnelGroup.class, tunnelGroupKeys, true);
            for (TunnelGroup tempTunnelGroup : tunnelGroupResults) {
                QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(tempTunnelGroup.getDevID().intValue());
                queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)tempTunnelGroup, Arrays.asList("switchResult", "workingTunnelDefectState", "protectTunnelDefectState"));
                pollService.addQueryJob(queryContext);
                pollService.poll();
                Collection devTunnelGroupList = queryContext.getQueryResult(TunnelGroup.class);
                if (null == devTunnelGroupList || devTunnelGroupList.isEmpty()) continue;
                TunnelGroup devTunnelGroup = (TunnelGroup)devTunnelGroupList.iterator().next();
                tempTunnelGroup.setSwitchResult(devTunnelGroup.getSwitchResult());
                tempTunnelGroup.setWorkingTunnelDefectState(devTunnelGroup.getWorkingTunnelDefectState());
                tempTunnelGroup.setProtectTunnelDefectState(devTunnelGroup.getProtectTunnelDefectState());
                record.addModify((Object)tempTunnelGroup, Arrays.asList("switchResult", "workingTunnelDefectState", "protectTunnelDefectState"));
            }
            dao.merge(TunnelGroup.class, true);
            for (TunnelGroup tunnelGroupKey : tunnelGroupKeys) {
                QAsnTunnelPGStatus asnTunnelPGStatus = new QAsnTunnelPGStatus();
                rsp.lstProtectGroupStatus.add((Object)asnTunnelPGStatus);
                boolean isFind = false;
                for (TunnelGroup tempTunnelGroup : tunnelGroupResults) {
                    if (!tunnelGroupKey.getDevID().equals(tempTunnelGroup.getDevID()) || !tunnelGroupKey.getVrID().equals(tempTunnelGroup.getVrID()) || !tunnelGroupKey.getWorkingTunnel().equals(tempTunnelGroup.getWorkingTunnel())) continue;
                    asnTunnelPGStatus.oProtectionGroupKey = (QAsnUniResID)tgpKeyToFdnAsnMap.get(tunnelGroupKey);
                    asnTunnelPGStatus.iSwitchResult = null == tempTunnelGroup.getSwitchResult() ? -1 : tempTunnelGroup.getSwitchResult();
                    asnTunnelPGStatus.iworkTnlStatus = tempTunnelGroup.getWorkingTunnelDefectState();
                    asnTunnelPGStatus.iProtectTnlStatus = tempTunnelGroup.getProtectTunnelDefectState();
                    if (null == asnTunnelPGStatus.poOperResult) {
                        asnTunnelPGStatus.poOperResult = new QAsnSingleReturn();
                    }
                    asnTunnelPGStatus.poOperResult.isSuccess = true;
                    asnTunnelPGStatus.poOperResult.retCode = 0;
                    asnTunnelPGStatus.poOperResult.reason = new byte[0];
                    isFind = true;
                    break;
                }
                if (isFind) continue;
                asnTunnelPGStatus.oProtectionGroupKey = (QAsnUniResID)tgpKeyToFdnAsnMap.get(tunnelGroupKey);
                if (null == asnTunnelPGStatus.poOperResult) {
                    asnTunnelPGStatus.poOperResult = new QAsnSingleReturn();
                }
                asnTunnelPGStatus.poOperResult.isSuccess = false;
                asnTunnelPGStatus.poOperResult.retCode = 555802862;
                asnTunnelPGStatus.poOperResult.reason = new byte[0];
                QAsnErrInfo errInfo = new QAsnErrInfo();
                errInfo.errCode = 555802862;
                errInfo.objID.add((Object)tunnelGroupKey.getDevID());
                errInfo.objName = StringUtil.globalByte((String)tunnelGroupKey.getWorkingTunnel());
                rsp.oReturn.result = 1107329319;
                if (null == rsp.oReturn.errList) {
                    rsp.oReturn.errList = new QAsnErrInfoList();
                }
                rsp.oReturn.errList.add((Object)errInfo);
                if (null == req.bestEffort || 1 == req.bestEffort) continue;
                break;
            }
        }
        catch (VMFException e) {
            rsp.oReturn.result = e.getErrorCode();
            this.logger.error("QueryTnlPGStatusTask queryByKey from database failed!", (Throwable)e);
        }
        finally {
            dao.rollback();
        }
    }
}

