/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tnl_vpn.QAsnQuerySvrTunnelRelationReq;
import com.huawei.network.qasn.m_q_ip_tnl_vpn.QAsnQuerySvrTunnelRelationRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpLsp;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.pwe3.fdn.VpwsPwFdnParser;
import com.huawei.vmf.adapter.fservice.pwe3.fdn.VpwsSwitchPwFdnParser;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsInstance;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsPw;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsSwitchInstance;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsSwitchPw;
import com.huawei.vmf.adapter.fservice.vpls.fdn.VplsPwFdnParser;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsInstance;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsLdpInst;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsLdpPw;
import com.huawei.vmf.adapter.fservice.vpls.service.IVplsService;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnTunnelSvrRelationInfoLdpTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnTunnelSvrRelationInfoStaticTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnTunnelSvrRelationInfoTeTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class QuerySvrTunnelRelationTask
extends AbstractQTask<QAsnQuerySvrTunnelRelationReq, QAsnQuerySvrTunnelRelationRsp> {
    private static final String FDN_TYPE_VRF = "VRF";
    private static final int NESERVICE_COMMONSERVICE_ISQUERYTUNNEL = 1;
    private static final int VPLS_PW_FDN_SPLIT_LENGTH = 6;

    protected void executeTask(QAsnQuerySvrTunnelRelationReq req, QAsnQuerySvrTunnelRelationRsp rsp, Task task) {
        if (req.poIgnoreQueryTunnel != null && req.poIgnoreQueryTunnel == 1) {
            rsp.oResult.result = 0;
            return;
        }
        LinkedList<String> vrfFdns = new LinkedList<String>();
        LinkedList<String> vsiPwFdns = new LinkedList<String>();
        LinkedList<String> pwe3PwFdns = new LinkedList<String>();
        LinkedList<String> pwe3SwitchPwFdns = new LinkedList<String>();
        this.assortFdns(req, vrfFdns, vsiPwFdns, pwe3PwFdns, pwe3SwitchPwFdns);
        try {
            Collection<VpwsInstance> vpwses;
            ArrayList<RsvpTeTunnel> teTunnels = new ArrayList<RsvpTeTunnel>();
            ArrayList<LdpLsp> ldpTunnels = new ArrayList<LdpLsp>();
            ArrayList<StaticTunnel> staticTunnels = new ArrayList<StaticTunnel>();
            MplsDevDao devDao = MplsDevDao.newInstance();
            if (!CollectionUtils.isEmpty(vrfFdns)) {
                Collection<L3vpnInstance> vrfs = this.parseVrfs(vrfFdns);
                Collection<L3vpnInstance> l3Instances = devDao.loadVrfTunnel(vrfs);
                teTunnels.addAll(this.getKefTeTunnels(l3Instances));
                ldpTunnels.addAll(this.getKefLdpTunnels(l3Instances));
                staticTunnels.addAll(this.getKefStaticTunnels(l3Instances));
            }
            if (!CollectionUtils.isEmpty(pwe3PwFdns)) {
                vpwses = this.parseVpwses(pwe3PwFdns);
                Collection<VpwsInstance> pwInstances = devDao.loadVpwsPwTunnel(vpwses);
                this.addVllPwTunnel(pwInstances, RsvpTeTunnel.class, teTunnels);
                this.addVllPwTunnel(pwInstances, LdpLsp.class, ldpTunnels);
                this.addVllPwTunnel(pwInstances, StaticTunnel.class, staticTunnels);
            }
            if (!CollectionUtils.isEmpty(pwe3SwitchPwFdns)) {
                vpwses = this.parseVpwseSwitches(pwe3SwitchPwFdns);
                devDao.loadVpwsSwitchPwTunnel(vpwses);
                this.addSwitchVllPwTunnel(vpwses, RsvpTeTunnel.class, teTunnels);
                this.addSwitchVllPwTunnel(vpwses, LdpLsp.class, ldpTunnels);
            }
            if (!CollectionUtils.isEmpty(vsiPwFdns)) {
                Object service = ExtendPointServiceMgr.getInstance().getExtendPoitService(IVplsService.class);
                if (null == service) {
                    return;
                }
                HashMap vsiPwMap = new HashMap();
                Collection vsis = ((IVplsService)service).loadVsiPwTunnel(vsiPwFdns, vsiPwMap);
                ((IVplsService)service).addVsiPwTunnel(vsis, vsiPwMap, RsvpTeTunnel.class, teTunnels);
                ((IVplsService)service).addVsiPwTunnel(vsis, vsiPwMap, LdpLsp.class, ldpTunnels);
                ((IVplsService)service).addVsiPwTunnel(vsis, vsiPwMap, StaticTunnel.class, staticTunnels);
            }
            AsnTranslationContext context = new AsnTranslationContext();
            context.setTransactionContext(new Context());
            QAsnTunnelSvrRelationInfoTeTranslator teTranslator = new QAsnTunnelSvrRelationInfoTeTranslator();
            Collection teAsns = teTranslator.encode(teTunnels, (IAsnTranslationContext)context);
            rsp.lstTunnelVrfRelationInfo.addAll(teAsns);
            QAsnTunnelSvrRelationInfoLdpTranslator ldpTranslator = new QAsnTunnelSvrRelationInfoLdpTranslator();
            Collection ldpAsns = ldpTranslator.encode(ldpTunnels, (IAsnTranslationContext)context);
            rsp.lstTunnelVrfRelationInfo.addAll(ldpAsns);
            QAsnTunnelSvrRelationInfoStaticTranslator staticTranslator = new QAsnTunnelSvrRelationInfoStaticTranslator();
            Collection staticAsns = staticTranslator.encode(staticTunnels, (IAsnTranslationContext)context);
            rsp.lstTunnelVrfRelationInfo.addAll(staticAsns);
            rsp.oResult.result = 0;
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnTunnelSvrRelationInfoTranslator encode failed!", (Throwable)e);
            rsp.oResult.result = e.getErrorCode();
        }
    }

    private <T extends VmfMO> void addSwitchVllPwTunnel(Collection<VpwsSwitchInstance> vpwses, Class<T> clazz, List<T> tunnels) {
        if (CollectionUtils.isEmpty(vpwses)) {
            return;
        }
        for (VpwsSwitchInstance vpws : vpwses) {
            if (CollectionUtils.isEmpty((Collection)vpws.getVpwsSwitchPws())) continue;
            for (VpwsSwitchPw pw : vpws.getVpwsSwitchPws()) {
                List keyrefs = pw.getKeyRefMos(clazz);
                if (CollectionUtils.isEmpty((Collection)keyrefs)) continue;
                for (VmfMO tunnel : keyrefs) {
                    tunnel.addKeyRefMo((VmfMO)pw);
                    tunnels.add(tunnel);
                }
            }
        }
    }

    private <T extends VmfMO> void addVllPwTunnel(Collection<VpwsInstance> vpwses, Class<T> clazz, List<T> tunnels) {
        if (CollectionUtils.isEmpty(vpwses)) {
            return;
        }
        for (VpwsInstance vpws : vpwses) {
            if (CollectionUtils.isEmpty((Collection)vpws.getVpwsPws())) continue;
            for (VpwsPw pw : vpws.getVpwsPws()) {
                List keyrefs = pw.getKeyRefMos(clazz);
                if (CollectionUtils.isEmpty((Collection)keyrefs)) continue;
                for (VmfMO tunnel : keyrefs) {
                    tunnel.addKeyRefMo((VmfMO)pw);
                    tunnels.add(tunnel);
                }
            }
        }
    }

    private <T extends VmfMO> void addVsiPwTunnel(Collection<VplsInstance> vsis, Class<T> clazz, List<T> tunnels) {
        if (CollectionUtils.isEmpty(vsis)) {
            return;
        }
        for (VplsInstance vsi : vsis) {
            VplsLdpInst inst = vsi.getVplsLdpInst();
            if (inst == null || CollectionUtils.isEmpty((Collection)inst.getVplsLdpPws())) continue;
            for (VplsLdpPw pw : inst.getVplsLdpPws()) {
                List keyrefs = pw.getKeyRefMos(clazz);
                if (CollectionUtils.isEmpty((Collection)keyrefs)) continue;
                for (VmfMO tunnel : keyrefs) {
                    tunnel.addKeyRefMo((VmfMO)pw);
                    tunnels.add(tunnel);
                }
            }
        }
    }

    private void assortFdns(QAsnQuerySvrTunnelRelationReq req, Collection<String> vrfFdns, Collection<String> vsiPwFdns, Collection<String> pwe3PwFdns, Collection<String> pwe3SwitchPwFdns) {
        for (Object resIdObj : req.lstServiceKey) {
            QAsnUniResID resId = (QAsnUniResID)resIdObj;
            String moc = StringUtil.globalString((byte[])resId.strMOC);
            String fdn = StringUtil.globalString((byte[])resId.strFDN);
            if (FDN_TYPE_VRF.equals(moc)) {
                vrfFdns.add(fdn);
                continue;
            }
            if ("PWSW".equals(moc)) {
                pwe3SwitchPwFdns.add(fdn);
                continue;
            }
            if (!"PW".equals(moc)) continue;
            Object service = ExtendPointServiceMgr.getInstance().getExtendPoitService(IVplsService.class);
            if (null == service) {
                return;
            }
            if (((IVplsService)service).isVplsPw(fdn)) {
                vsiPwFdns.add(fdn);
                continue;
            }
            pwe3PwFdns.add(fdn);
        }
    }

    private LdpLsp copyTunnel(LdpLsp tunnel) {
        LdpLsp newTunnel = new LdpLsp();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)newTunnel);
        newTunnel.setLspAddr(tunnel.getLspAddr());
        return newTunnel;
    }

    private RsvpTeTunnel copyTunnel(RsvpTeTunnel tunnel) {
        RsvpTeTunnel newTunnel = new RsvpTeTunnel();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)newTunnel);
        newTunnel.setTunnelName(tunnel.getTunnelName());
        return newTunnel;
    }

    private StaticTunnel copyStaticTunnel(StaticTunnel tunnel) {
        StaticTunnel newTunnel = new StaticTunnel();
        AsnTranslatorUtil.copyDevAndVrId((VmfMO)tunnel, (VmfMO)newTunnel);
        newTunnel.setEgressLsrId(tunnel.getEgressLsrId());
        newTunnel.setIngressLsrId(tunnel.getIngressLsrId());
        newTunnel.setTunnelName(tunnel.getTunnelName());
        newTunnel.setFdn(tunnel.getFdn());
        newTunnel.setTunnelId(tunnel.getTunnelId());
        newTunnel.setLsrRole(tunnel.getLsrRole());
        return newTunnel;
    }

    private <T extends VmfMO> Collection<LdpLsp> getKefLdpTunnels(Collection<T> mos) {
        if (CollectionUtils.isEmpty(mos)) {
            return Collections.emptyList();
        }
        ArrayList<LdpLsp> resultList = new ArrayList<LdpLsp>();
        for (VmfMO mo : mos) {
            List tunnels = mo.getKeyRefMos(LdpLsp.class);
            if (CollectionUtils.isEmpty((Collection)tunnels)) continue;
            for (LdpLsp tunnel : tunnels) {
                LdpLsp newTunnel = this.copyTunnel(tunnel);
                newTunnel.addKeyRefMo(mo);
                resultList.add(newTunnel);
            }
        }
        return resultList;
    }

    private <T extends VmfMO> Collection<RsvpTeTunnel> getKefTeTunnels(Collection<T> mos) {
        if (CollectionUtils.isEmpty(mos)) {
            return Collections.emptyList();
        }
        ArrayList<RsvpTeTunnel> resultList = new ArrayList<RsvpTeTunnel>();
        for (VmfMO mo : mos) {
            List tunnels = mo.getKeyRefMos(RsvpTeTunnel.class);
            if (CollectionUtils.isEmpty((Collection)tunnels)) continue;
            for (RsvpTeTunnel tunnel : tunnels) {
                RsvpTeTunnel newTunnel = this.copyTunnel(tunnel);
                newTunnel.addKeyRefMo(mo);
                resultList.add(newTunnel);
            }
        }
        return resultList;
    }

    private <T extends VmfMO> Collection<StaticTunnel> getKefStaticTunnels(Collection<T> mos) {
        if (CollectionUtils.isEmpty(mos)) {
            return Collections.emptyList();
        }
        ArrayList<StaticTunnel> resultList = new ArrayList<StaticTunnel>();
        for (VmfMO mo : mos) {
            List tunnels = mo.getKeyRefMos(StaticTunnel.class);
            if (CollectionUtils.isEmpty((Collection)tunnels)) continue;
            for (StaticTunnel tunnel : tunnels) {
                StaticTunnel newTunnel = this.copyStaticTunnel(tunnel);
                newTunnel.addKeyRefMo(mo);
                resultList.add(newTunnel);
            }
        }
        return resultList;
    }

    private boolean isVplsPw(String fdn) {
        String[] ss = fdn.split("\\|");
        return ss.length == 6;
    }

    private Collection<VpwsInstance> parseVpwses(Collection<String> pwe3PwFdns) {
        VpwsPwFdnParser fdnParser = new VpwsPwFdnParser();
        ArrayList<VpwsPw> fdnPws = new ArrayList<VpwsPw>();
        for (String fdn : pwe3PwFdns) {
            VpwsPw pw = fdnParser.getIndexMo(fdn);
            fdnPws.add(pw);
        }
        String[] fieldNames = new String[]{"devID", "vrID", "pwId", "pwType"};
        Collection dbPws = null;
        try {
            dbPws = MplsDao.newInstance().queryByFields(VpwsPw.class, fieldNames, fdnPws, false);
        }
        catch (VMFException e) {
            this.getLogger().error("QuerySvrTunnelRelationTask query VpwsPw failed!", (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)dbPws)) {
            return Collections.emptyList();
        }
        HashMap<String, VpwsInstance> vpwsMap = new HashMap<String, VpwsInstance>();
        for (VpwsPw pw : dbPws) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{pw.getDevID(), pw.getVrID(), pw.getInstanceType(), pw.getInstanceName()});
            VpwsInstance vpws = (VpwsInstance)vpwsMap.get(key);
            if (vpws == null) {
                vpws = new VpwsInstance();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)pw, (VmfMO)vpws);
                vpws.setInstanceType(pw.getInstanceType());
                vpws.setInstanceName(pw.getInstanceName());
                vpwsMap.put(key, vpws);
            }
            vpws.addVpwsPws(Arrays.asList(pw));
        }
        return vpwsMap.values();
    }

    private Collection<VpwsSwitchInstance> parseVpwseSwitches(Collection<String> pwe3SwitchPwFdns) {
        VpwsSwitchPwFdnParser fdnParser = new VpwsSwitchPwFdnParser();
        ArrayList<VpwsSwitchPw> fdnPws = new ArrayList<VpwsSwitchPw>();
        for (String fdn : pwe3SwitchPwFdns) {
            VpwsSwitchPw pw = fdnParser.getIndexMo(fdn);
            fdnPws.add(pw);
        }
        String[] fieldNames = new String[]{"devID", "vrID", "pwId", "pwType"};
        Collection dbPws = null;
        try {
            dbPws = MplsDao.newInstance().queryByFields(VpwsSwitchPw.class, fieldNames, fdnPws, false);
        }
        catch (VMFException e) {
            this.getLogger().error("QuerySvrTunnelRelationTask query VpwsPw failed!", (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)dbPws)) {
            return Collections.emptyList();
        }
        HashMap<String, VpwsSwitchInstance> vpwsMap = new HashMap<String, VpwsSwitchInstance>();
        for (VpwsSwitchPw pw : dbPws) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{pw.getDevID(), pw.getVrID(), pw.getInstanceType(), pw.getInstanceName()});
            VpwsSwitchInstance vpws = (VpwsSwitchInstance)vpwsMap.get(key);
            VpwsSwitchPw newPw = new VpwsSwitchPw();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)pw, (VmfMO)newPw);
            newPw.setPwId(pw.getPwId());
            newPw.setPwType(pw.getPwType());
            if (vpws == null) {
                vpws = new VpwsSwitchInstance();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)pw, (VmfMO)vpws);
                vpws.setInstanceType(pw.getInstanceType());
                vpws.setInstanceName(pw.getInstanceName());
                vpwsMap.put(key, vpws);
            }
            vpws.addVpwsSwitchPws(Arrays.asList(newPw));
        }
        return vpwsMap.values();
    }

    private Collection<L3vpnInstance> parseVrfs(Collection<String> vrfFdns) {
        L3vpnInstanceFdnParser fdnParser = new L3vpnInstanceFdnParser();
        ArrayList<L3vpnInstance> vrfs = new ArrayList<L3vpnInstance>();
        for (String fdn : vrfFdns) {
            vrfs.add(fdnParser.getIndexMo(fdn));
        }
        return vrfs;
    }

    private Collection<VplsInstance> parseVsis(Collection<String> vsiFdns) {
        VplsPwFdnParser fdnParser = new VplsPwFdnParser();
        HashMap<String, VplsInstance> vsiMap = new HashMap<String, VplsInstance>();
        for (String fdn : vsiFdns) {
            VplsLdpPw pw = fdnParser.getIndexMo(fdn);
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{pw.getDevID(), pw.getVrID(), pw.getInstanceName()});
            VplsInstance vsi = null;
            if (vsiMap.containsKey(key)) {
                vsi = (VplsInstance)vsiMap.get(key);
                vsi.getVplsLdpInst().addVplsLdpPws(Arrays.asList(pw));
                continue;
            }
            vsi = new VplsInstance();
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)pw, (VmfMO)vsi);
            vsi.setInstanceName(pw.getInstanceName());
            VplsLdpInst inst = new VplsLdpInst();
            vsi.setVplsLdpInst(inst);
            AsnTranslatorUtil.copyDevAndVrId((VmfMO)pw, (VmfMO)inst);
            inst.setVplsPwLdpSignal(VplsLdpInst.VPLS_PW_LDP_SIGNAL_ENUM.PW_LDP_SIGNAL);
            inst.setInstanceName(pw.getInstanceName());
            inst.addVplsLdpPws(Arrays.asList(pw));
            vsiMap.put(key, vsi);
        }
        return vsiMap.values();
    }
}

