/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRsvpTunnelFrrStatusInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRsvpTunnelFrrStatusInfoList;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryRsvpTunnelFrrStatusReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryRsvpTunnelFrrStatusRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.Lsp;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnRsvpTunnelFrrStatusInfoTranslator;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QueryRsvpTunnelFrrStatusTask
extends AbstractQTask<QAsnQueryRsvpTunnelFrrStatusReq, QAsnQueryRsvpTunnelFrrStatusRsp> {
    private static Integer FRR_IN_USED = 2;

    protected void executeTask(QAsnQueryRsvpTunnelFrrStatusReq req, QAsnQueryRsvpTunnelFrrStatusRsp rsp, Task task) {
        rsp.oResult.result = 0;
        for (Object obj : req.lstTunnelKey) {
            QAsnUniResID uniResID = (QAsnUniResID)obj;
            QAsnRsvpTunnelFrrStatusInfoList lspInfos = this.queryMplsTeTunnelFromDevByTunnelKey(uniResID, rsp.oResult);
            if (null == lspInfos) continue;
            rsp.lstRsvpTunnelFrrStatusInfo.addAll((Collection)lspInfos);
        }
    }

    private QAsnRsvpTunnelFrrStatusInfoList queryMplsTeTunnelFromDevByTunnelKey(QAsnUniResID uniResID, QAsnErrInfoReturn errorInfo) {
        RsvpTeTunnelFdnParser fdmParser = new RsvpTeTunnelFdnParser();
        RsvpTeTunnel tunnel = (RsvpTeTunnel)fdmParser.getIndexMo(uniResID);
        DefaultMOService pollService = new DefaultMOService();
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(tunnel.getDevID().intValue());
        QAsnRsvpTunnelFrrStatusInfoTranslator translator = new QAsnRsvpTunnelFrrStatusInfoTranslator();
        QAsnRsvpTunnelFrrStatusInfoList rsvpTunnelFrrStatusInfos = new QAsnRsvpTunnelFrrStatusInfoList();
        queryContext.addQueryAttributes(FeatureName.MPLS, (VmfMO)tunnel, null);
        pollService.addQueryJob(queryContext);
        try {
            pollService.poll();
        }
        catch (Exception e) {
            this.getLogger().error("query device[" + tunnel.getDevID() + "] Lsp failed", (Throwable)e);
            errorInfo.result = 1107499878;
            return null;
        }
        Collection rsvpTeTunnels = queryContext.getQueryResult(RsvpTeTunnel.class);
        if (CollectionUtils.isEmpty((Collection)rsvpTeTunnels)) {
            return null;
        }
        for (RsvpTeTunnel rsvpTeTunnel : rsvpTeTunnels) {
            Collection lsps;
            if (rsvpTeTunnel == null || CollectionUtils.isEmpty((Collection)(lsps = rsvpTeTunnel.getLsps()))) continue;
            for (Lsp lsp : lsps) {
                if (FRR_IN_USED.equals(lsp.getMplsTunnelLocalProtectInUse())) {
                    lsp.setMplsTunnelLocalProtectInUse(Lsp.MPLS_TUNNEL_LOCAL_PROTECT_IN_USE_ENUM.FRR_AVILABLE);
                } else {
                    lsp.setMplsTunnelLocalProtectInUse(Lsp.MPLS_TUNNEL_LOCAL_PROTECT_IN_USE_ENUM.FRR_NOT_EXIST);
                }
                try {
                    QAsnRsvpTunnelFrrStatusInfo info = (QAsnRsvpTunnelFrrStatusInfo)translator.encode(lsp, (IAsnTranslationContext)new AsnTranslationContext());
                    info.oNotifyTnlKey = uniResID;
                    info.iNeID = lsp.getDevID();
                    rsvpTunnelFrrStatusInfos.add((Object)info);
                }
                catch (VMFException e) {
                    this.getLogger().error("QAsnRsvpTunnelFrrStatusInfo encode error", (Throwable)e);
                }
            }
        }
        return rsvpTunnelFrrStatusInfos;
    }
}

