/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRSVPTunnelInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRSVPTunnelInfoList;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryRsvpReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryRsvpRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.common.EOperResultType;
import com.huawei.vmf.adapter.framework.service.QueryResult;
import com.huawei.vmf.adapter.framework.task.DefaultQueryByFDNTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnRSVPTunnelInfoTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QueryRsvpTask
extends DefaultQueryByFDNTask<QAsnQueryRsvpReq, QAsnQueryRsvpRsp, RsvpTeTunnel> {
    public QueryRsvpTask(Collection<QAsnUniResID> fdns, QAsnRSVPTunnelInfoList queryResults, QAsnErrInfoReturn operResult) {
        super(fdns, (IFdnParser)new RsvpTeTunnelFdnParser(), null, (IAsnTranslator)new QAsnRSVPTunnelInfoTranslator(), (Collection)queryResults, (FStruct)operResult, true, true);
    }

    protected void doAfterEncodeRsp(QAsnQueryRsvpReq req, QAsnQueryRsvpRsp rsp, QueryResult result) {
        if (EOperResultType.FAILED == result.getOperResult()) {
            return;
        }
        Collection queryMOs = result.getQueryResult(RsvpTeTunnel.class);
        List<RsvpTeTunnel> notFoundMOs = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)queryMOs)) {
            rsp.oResult.result = 1107499878;
            notFoundMOs = this.getFilterMos();
        } else if (queryMOs.size() < this.getFilterMos().size()) {
            rsp.oResult.result = 0;
            for (RsvpTeTunnel mo : this.getFilterMos()) {
                if (queryMOs.contains(mo)) continue;
                notFoundMOs.add(mo);
            }
        } else {
            rsp.oResult.result = 0;
            return;
        }
        for (RsvpTeTunnel mo : notFoundMOs) {
            rsp.lstRSVPTunnel.add((Object)this.getErrorResultObj(mo));
        }
    }

    protected void doExtendedProcAfterQuery(QAsnQueryRsvpReq req, QAsnQueryRsvpRsp rsp, QueryResult result) {
        Collection mos = result.getQueryResult(RsvpTeTunnel.class);
        if (CollectionUtils.isEmpty((Collection)mos)) {
            return;
        }
        RsvpTeTunnelFdnParser fdnParser = new RsvpTeTunnelFdnParser();
        for (RsvpTeTunnel mo : mos) {
            mo.setFdn(fdnParser.getFdn((VmfMO)mo));
        }
        try {
            MplsDao.newInstance().loadTunnelIfAndKeyRef(mos, true);
        }
        catch (VMFException e) {
            this.getLogger().error("QueryRsvpTask MplsDao loadRsvpTeTunnelInterface failed!", (Throwable)e);
        }
    }

    private QAsnRSVPTunnelInfo getErrorResultObj(RsvpTeTunnel mo) {
        RsvpTeTunnelFdnParser fdnParser = new RsvpTeTunnelFdnParser();
        QAsnRSVPTunnelInfo asn = new QAsnRSVPTunnelInfo();
        AsnUtil.setDefaultAsnValue((FStruct)asn);
        asn.oTunnelBase.oTunnelKey = fdnParser.getUniResID((VmfMO)mo);
        QAsnErrInfo err = new QAsnErrInfo();
        err.errCode = 0x22000022;
        err.objName = StringUtil.globalByte((String)mo.getFdn());
        err.objID.add((Object)mo.getDevID());
        asn.oTunnelBase.poOperResult = err;
        return asn;
    }
}

