/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelPGInfoList;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryProtectionGroupReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryProtectionGroupRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.common.EOperResultType;
import com.huawei.vmf.adapter.framework.service.QueryResult;
import com.huawei.vmf.adapter.framework.task.DefaultQueryByFDNTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.TunnelGroupFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelGroup;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelPGInfoTranslator;
import java.util.Collection;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.apache.commons.collections.CollectionUtils;

public class QueryProtectionGroupTask
extends DefaultQueryByFDNTask<QAsnQueryProtectionGroupReq, QAsnQueryProtectionGroupRsp, TunnelGroup> {
    public QueryProtectionGroupTask(Collection<QAsnUniResID> fdns, QAsnTunnelPGInfoList rspQueryResults, QAsnErrInfoReturn operResult) {
        super(fdns, (IFdnParser)new TunnelGroupFdnParser(), null, (IAsnTranslator)new QAsnTunnelPGInfoTranslator(), (Collection)rspQueryResults, (FStruct)operResult, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExtendedProcAfterQuery(QAsnQueryProtectionGroupReq req, QAsnQueryProtectionGroupRsp rsp, QueryResult result) {
        Collection tunnelGroupInfoList = result.getQueryResult(TunnelGroup.class);
        if (CollectionUtils.isEmpty((Collection)tunnelGroupInfoList)) {
            return;
        }
        Collection<RsvpTeTunnel> tunnelResults = null;
        try {
            tunnelResults = MplsDao.newInstance().queryTunnelKey(tunnelGroupInfoList);
            Map<String, RsvpTeTunnel> tunnelMap = MplsUtil.translaterTunnelMap(tunnelResults);
            for (TunnelGroup tempTunnelGroup : tunnelGroupInfoList) {
                RsvpTeTunnel mainTunnelKeyInfo = tunnelMap.get(tempTunnelGroup.getDevID() + tempTunnelGroup.getWorkingTunnel());
                RsvpTeTunnel backupTunnelKeyInfo = tunnelMap.get(tempTunnelGroup.getDevID() + tempTunnelGroup.getProtectTunnel());
                tempTunnelGroup.addKeyRefMo((VmfMO)mainTunnelKeyInfo);
                tempTunnelGroup.addKeyRefMo((VmfMO)backupTunnelKeyInfo);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("QueryProtectionGroupTask doExtendedProcAfterQuery error.", (Throwable)e);
            if (1 != req.bestEffort) {
                result.setErrorCode(e.getErrorCode());
                result.setOperResult(EOperResultType.FAILED);
            }
        }
        finally {
            this.getDao().rollback();
        }
    }
}

