/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnNeIDAndVrID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelPGInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryProtectionGroupByNeIDReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryProtectionGroupByNeIDRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelGroup;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelPGInfoTranslator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class QueryProtectionGroupByNeIDTask
extends AbstractQTask<QAsnQueryProtectionGroupByNeIDReq, QAsnQueryProtectionGroupByNeIDRsp> {
    private IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask(QAsnQueryProtectionGroupByNeIDReq req, QAsnQueryProtectionGroupByNeIDRsp rsp, Task task) {
        rsp.oResult.result = 0;
        QAsnTunnelPGInfoTranslator tunnelPGInfoTranslator = new QAsnTunnelPGInfoTranslator();
        for (Object neIDAndVrIDObj : req.lstNeIDAndVrID) {
            QAsnNeIDAndVrID neIDAndVrID = (QAsnNeIDAndVrID)neIDAndVrIDObj;
            int devID = neIDAndVrID.iNeID;
            try {
                Collection tunnelGroupResults = this.dao.queryByNeID(TunnelGroup.class, Arrays.asList(devID), true);
                Collection<RsvpTeTunnel> tunnelResults = MplsDao.newInstance().queryTunnelKey(tunnelGroupResults);
                Map<String, RsvpTeTunnel> tunnelMap = MplsUtil.translaterTunnelMap(tunnelResults);
                for (TunnelGroup tempTunnelGroup : tunnelGroupResults) {
                    RsvpTeTunnel mainTunnelKeyInfo = tunnelMap.get(tempTunnelGroup.getDevID() + tempTunnelGroup.getWorkingTunnel());
                    RsvpTeTunnel backupTunnelKeyInfo = tunnelMap.get(tempTunnelGroup.getDevID() + tempTunnelGroup.getProtectTunnel());
                    tempTunnelGroup.addKeyRefMo((VmfMO)mainTunnelKeyInfo);
                    tempTunnelGroup.addKeyRefMo((VmfMO)backupTunnelKeyInfo);
                    QAsnTunnelPGInfo tunnelGroupInfo = new QAsnTunnelPGInfo();
                    tunnelPGInfoTranslator.encode(tempTunnelGroup, (IAsnTranslationContext)new AsnTranslationContext());
                    rsp.lstProtectionGroup.add((Object)tunnelGroupInfo);
                }
            }
            catch (VMFException e) {
                this.getLogger().error("QueryProtectionGroupByNeIDTask executeTask error,", (Throwable)e);
                ErrorInfo errorInfo = new ErrorInfo(e.getErrorCode(), e.getErrorMessage());
                QAsnErrInfo error = AsnTranslatorUtil.translate2QAsnErrInfo((ErrorInfo)errorInfo, (int)devID);
                rsp.oResult.errList.add((Object)error);
                rsp.lstFail.add((Object)devID);
                if (null == req.bestEffort || 1 == req.bestEffort) continue;
                break;
            }
            finally {
                this.dao.rollback();
            }
        }
    }
}

