/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnQueryProtectStatusAndReason;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnQueryProtectStatusAndReasonList;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryProtectStatusAndReasonReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryProtectStatusAndReasonRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelAdv;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelPathConstraint;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QueryProtectStatusAndReasonTask
extends AbstractQTask<QAsnQueryProtectStatusAndReasonReq, QAsnQueryProtectStatusAndReasonRsp> {
    protected void executeTask(QAsnQueryProtectStatusAndReasonReq req, QAsnQueryProtectStatusAndReasonRsp rsp, Task task) {
        rsp.oResult.result = 0;
        HashSet<RsvpTeTunnel> tunnelKeys = new HashSet<RsvpTeTunnel>();
        RsvpTeTunnelFdnParser fdnParser = new RsvpTeTunnelFdnParser();
        for (Object tunnelKey : req.lstTunnelKey) {
            QAsnUniResID resId = (QAsnUniResID)tunnelKey;
            tunnelKeys.add((RsvpTeTunnel)fdnParser.getIndexMo(resId));
        }
        try {
            this.getHotstandbyTunnels(tunnelKeys, rsp.lstProtectStatusAndReason);
            this.queryHotStandbyStatusFromDev(tunnelKeys, rsp.lstProtectStatusAndReason);
        }
        catch (VMFException e) {
            this.getLogger().error("executeTask failed", (Throwable)e);
            rsp.oResult.result = e.getErrorCode();
        }
        for (RsvpTeTunnel tunnel : tunnelKeys) {
            QAsnQueryProtectStatusAndReason status = new QAsnQueryProtectStatusAndReason();
            AsnUtil.setDefaultAsnValue((FStruct)status);
            status.iBackUpStatus = AsnUtil.intValue((Integer)tunnel.getWorkingLspType());
            status.strSwitchReanson = StringUtil.globalByte((String)tunnel.getHotStandbySwitchReason());
            status.oTnlKey = new RsvpTeTunnelFdnParser().getUniResID((VmfMO)tunnel);
            if (tunnel.getRsvpTeTunnelPathConstraint() != null) {
                status.poiBackUpLspRunStatus = tunnel.getRsvpTeTunnelPathConstraint().getHotStandbyLspState();
            }
            rsp.lstProtectStatusAndReason.add((Object)status);
        }
    }

    private QAsnQueryProtectStatusAndReason encode(RsvpTeTunnel tunnel, ErrorInfo err) {
        QAsnQueryProtectStatusAndReason status = new QAsnQueryProtectStatusAndReason();
        AsnUtil.setDefaultAsnValue((FStruct)status);
        status.iBackUpStatus = -1;
        status.oTnlKey = new RsvpTeTunnelFdnParser().getUniResID((VmfMO)tunnel);
        if (err != null) {
            status.poOperResult = new QAsnErrInfo();
            AsnUtil.setDefaultAsnValue((FStruct)status.poOperResult);
            status.poOperResult.errCode = err.getErrorCode();
            status.poOperResult.objName = StringUtil.globalByte((String)tunnel.getFdn());
            status.poOperResult.strOperDesc = StringUtil.globalByte((String)err.getErrorMessage());
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHotstandbyTunnels(Collection<RsvpTeTunnel> keys, QAsnQueryProtectStatusAndReasonList protectStatus) throws VMFException {
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            dao.queryByParentKey(RsvpTeTunnelAdv.class, RsvpTeTunnel.class, keys);
            Iterator<RsvpTeTunnel> it = keys.iterator();
            while (it.hasNext()) {
                RsvpTeTunnel tunnel = it.next();
                if (tunnel.getRsvpTeTunnelAdv() != null && Boolean.TRUE.equals(tunnel.getRsvpTeTunnelAdv().getHotStandbyEnable())) continue;
                it.remove();
                QAsnQueryProtectStatusAndReason status = this.encode(tunnel, null);
                protectStatus.add((Object)status);
            }
        }
        finally {
            dao.rollback();
        }
    }

    private void queryHotStandbyStatusFromDev(Set<RsvpTeTunnel> tunnelKeys, QAsnQueryProtectStatusAndReasonList protectStatus) throws VMFException {
        if (CollectionUtils.isEmpty(tunnelKeys)) {
            return;
        }
        DefaultMOService pollService = new DefaultMOService();
        for (RsvpTeTunnel tunnel : tunnelKeys) {
            RsvpTeTunnelPathConstraint pathAttr = new RsvpTeTunnelPathConstraint();
            pathAttr.setDevID(tunnel.getDevID());
            pathAttr.setVrID(tunnel.getVrID());
            pathAttr.setTunnelName(tunnel.getTunnelName());
            tunnel.setRsvpTeTunnelPathConstraint(pathAttr);
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(tunnel.getDevID().intValue());
            if (queryContext == null) {
                queryContext = new QuerySchemaTranslatorContext(tunnel.getDevID().intValue());
                pollService.addQueryJob(queryContext);
            }
            queryContext.addQueryAttributes(tunnel.getFeatureName(), (VmfMO)tunnel, Arrays.asList("workingLspType", "hotStandbySwitchReason", "rsvpTeTunnelPathConstraint"));
            queryContext.addQueryAttributes(tunnel.getFeatureName(), (VmfMO)pathAttr, Arrays.asList("hotStandbyLspState"));
        }
        pollService.poll();
        Iterator<RsvpTeTunnel> it = tunnelKeys.iterator();
        while (it.hasNext()) {
            RsvpTeTunnel tunnel;
            tunnel = it.next();
            ErrorInfo err = pollService.getErrorInfo((VmfMO)tunnel);
            if (err == null || 0 == err.getErrorCode()) continue;
            it.remove();
            QAsnQueryProtectStatusAndReason status = this.encode(tunnel, err);
            protectStatus.add((Object)status);
        }
    }
}

