/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_common_op.QAsnQueryNodeIDByLsrIDReq;
import com.huawei.network.qasn.m_q_ip_common_op.QAsnQueryNodeIDByLsrIDRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevSysInfo;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsCommonCfg;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnLsrNodeIDPairTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.springframework.util.CollectionUtils;

public class QueryNodeIDByLsrIDTask
extends AbstractQTask<QAsnQueryNodeIDByLsrIDReq, QAsnQueryNodeIDByLsrIDRsp> {
    protected void executeTask(QAsnQueryNodeIDByLsrIDReq req, QAsnQueryNodeIDByLsrIDRsp rsp, Task task) {
        ArrayList<MplsCommonCfg> conditions = new ArrayList<MplsCommonCfg>(req.lstLsrID.size());
        for (Object obj : req.lstLsrID) {
            String lsr = StringUtil.globalString((byte[])((byte[])obj));
            MplsCommonCfg cfg = new MplsCommonCfg();
            cfg.setMplsLsrID(lsr);
            conditions.add(cfg);
        }
        try {
            MplsDao dao = MplsDao.newInstance();
            String[] fieldNames = new String[]{"mplsLsrID"};
            Collection cfgs = dao.queryByFields(MplsCommonCfg.class, fieldNames, conditions, false);
            this.filterNotExistDev(cfgs);
            QAsnLsrNodeIDPairTranslator translator = new QAsnLsrNodeIDPairTranslator();
            AsnTranslationContext context = new AsnTranslationContext();
            Collection asns = translator.encode(cfgs, (IAsnTranslationContext)context);
            rsp.lstLsrNodeIDPair.addAll(asns);
            rsp.oResult.result = 0;
        }
        catch (VMFException e) {
            this.getLogger().error("QueryNodeIDByLsrID failed!", (Throwable)e);
            rsp.oResult.result = e.getErrorCode();
        }
    }

    private void filterNotExistDev(Collection<MplsCommonCfg> mplsCfgs) throws VMFException {
        if (CollectionUtils.isEmpty(mplsCfgs)) {
            return;
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        ArrayList<DevSysInfo> devIds = new ArrayList<DevSysInfo>();
        for (MplsCommonCfg mplsCfg : mplsCfgs) {
            DevSysInfo dev = new DevSysInfo();
            dev.setDevID(mplsCfg.getDevID());
            dev.setVrID(mplsCfg.getVrID());
            devIds.add(dev);
        }
        Collection existDevs = dao.exists(DevSysInfo.class, devIds);
        if (CollectionUtils.isEmpty((Collection)existDevs)) {
            mplsCfgs.clear();
        }
        HashSet<Integer> existDevIDs = new HashSet<Integer>();
        for (DevSysInfo dev : existDevs) {
            existDevIDs.add(dev.getDevID());
        }
        Iterator<MplsCommonCfg> it = mplsCfgs.iterator();
        while (it.hasNext()) {
            MplsCommonCfg mplsCfg = it.next();
            if (existDevIDs.contains(mplsCfg.getDevID())) continue;
            this.getLogger().error("dev {} not exist", (Object)mplsCfg.getDevID());
            it.remove();
        }
    }
}

