/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnMplsInfoList;
import com.huawei.network.qasn.m_q_ip_common_op.QAsnQueryMplsReq;
import com.huawei.network.qasn.m_q_ip_common_op.QAsnQueryMplsRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.common.EOperResultType;
import com.huawei.vmf.adapter.framework.service.QueryResult;
import com.huawei.vmf.adapter.framework.task.DefaultQueryByDevIDAndAttributesTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpInstance;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsCommonCfg;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsTeSite;
import com.huawei.vmf.adapter.fservice.pwe3.model.L2vpnGlobal;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnMplsInfoTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QueryMplsTask
extends DefaultQueryByDevIDAndAttributesTask<QAsnQueryMplsReq, QAsnQueryMplsRsp, MplsCommonCfg> {
    public QueryMplsTask(Collection<Integer> devIDs, LinkedHashMap<String, Object> fieldValues, QAsnMplsInfoList queryResults, QAsnErrInfoReturn operResult) {
        super(devIDs, fieldValues, MplsCommonCfg.class, (IAsnTranslator)new QAsnMplsInfoTranslator(), (Collection)queryResults, (FStruct)operResult, true, false);
    }

    protected void doExtendedProcAfterQuery(QAsnQueryMplsReq req, QAsnQueryMplsRsp rsp, QueryResult result) {
        Collection mplsCommonCfgs = result.getQueryResult(MplsCommonCfg.class);
        result.setOperResult(EOperResultType.SUCCESS);
        if (CollectionUtils.isEmpty((Collection)mplsCommonCfgs)) {
            return;
        }
        try {
            this.loadMplsTeSites(mplsCommonCfgs);
            this.loadLdpInstances(mplsCommonCfgs);
            this.loadL2vpnGlobals(mplsCommonCfgs);
        }
        catch (Exception e) {
            this.getLogger().error("query keyref mo (MplsTeSite or LdpPeer) error. devIDs=" + this.getDevIDs(), (Throwable)e);
            result.setOperResult(EOperResultType.FAILED);
            return;
        }
    }

    private void loadL2vpnGlobals(Collection<MplsCommonCfg> mplsCommonCfgs) throws VMFException {
        Collection l2vpnGlobals = this.getDao().queryByNeID(L2vpnGlobal.class, this.getDevIDs(), false);
        for (MplsCommonCfg mplsCommonCfg : mplsCommonCfgs) {
            ArrayList<L2vpnGlobal> refL2vpnGlobals = new ArrayList<L2vpnGlobal>();
            for (L2vpnGlobal l2vpnGlobal : l2vpnGlobals) {
                if (!l2vpnGlobal.getDevID().equals(mplsCommonCfg.getDevID()) || !l2vpnGlobal.getVrID().equals(mplsCommonCfg.getVrID())) continue;
                refL2vpnGlobals.add(l2vpnGlobal);
            }
            if (CollectionUtils.isEmpty(refL2vpnGlobals)) continue;
            mplsCommonCfg.addKeyRefMos(refL2vpnGlobals);
        }
    }

    private void loadLdpInstances(Collection<MplsCommonCfg> mplsCommonCfgs) throws VMFException {
        Collection ldpInstances = this.getDao().queryByNeID(LdpInstance.class, this.getDevIDs(), true);
        for (MplsCommonCfg mplsCommonCfg : mplsCommonCfgs) {
            ArrayList<LdpInstance> refLdpInstances = new ArrayList<LdpInstance>();
            for (LdpInstance ldpInstance : ldpInstances) {
                if (!ldpInstance.getDevID().equals(mplsCommonCfg.getDevID()) || !ldpInstance.getVrID().equals(mplsCommonCfg.getVrID())) continue;
                refLdpInstances.add(ldpInstance);
            }
            if (CollectionUtils.isEmpty(refLdpInstances)) continue;
            mplsCommonCfg.addKeyRefMos(refLdpInstances);
        }
    }

    private void loadMplsTeSites(Collection<MplsCommonCfg> mplsCommonCfgs) throws VMFException {
        Collection mplsTeSites = this.getDao().queryByNeID(MplsTeSite.class, this.getDevIDs(), false);
        for (MplsCommonCfg mplsCommonCfg : mplsCommonCfgs) {
            ArrayList<MplsTeSite> refMplsTeSites = new ArrayList<MplsTeSite>();
            for (MplsTeSite mplsTe : mplsTeSites) {
                if (!mplsTe.getDevID().equals(mplsCommonCfg.getDevID()) || !mplsTe.getVrID().equals(mplsCommonCfg.getVrID())) continue;
                refMplsTeSites.add(mplsTe);
            }
            if (CollectionUtils.isEmpty(refMplsTeSites)) continue;
            mplsCommonCfg.addKeyRefMos(refMplsTeSites);
        }
    }
}

