/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryLDPLspRouteReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryLDPLspRouteRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.mpls.model.CrossConnect;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpLsp;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnLDPLspHopInfoTranslator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class QueryLDPLspRouteTask
extends AbstractQTask<QAsnQueryLDPLspRouteReq, QAsnQueryLDPLspRouteRsp> {
    private static final String LDP_LSP_FEC_MASK_SLASH = "/";
    private static final int LDP_VIRTUAL_TUNNEL_DESTIP_MASK = 32;

    protected void executeTask(QAsnQueryLDPLspRouteReq req, QAsnQueryLDPLspRouteRsp rsp, Task task) {
        MplsDevDao dao = MplsDevDao.newInstance();
        String destinationIp = StringUtil.globalString((byte[])req.strDestinationIP);
        String strFilterFec = destinationIp + LDP_LSP_FEC_MASK_SLASH + 32;
        rsp.oResult.result = 0;
        for (Object obj : req.lstNeID) {
            Integer devID = (Integer)obj;
            try {
                List<LdpLsp> ldpLsps = dao.queryLdpLsp(devID);
                Iterator<LdpLsp> iter = ldpLsps.iterator();
                while (iter.hasNext()) {
                    LdpLsp mo = iter.next();
                    if (LdpLsp.LSP_TYPE_ENUM.INGRESS.equals(mo.getLspType())) {
                        iter.remove();
                        continue;
                    }
                    if (strFilterFec.equals(mo.getLspAddr())) continue;
                    iter.remove();
                }
                QAsnLDPLspHopInfoTranslator translator = new QAsnLDPLspHopInfoTranslator();
                Collection<CrossConnect> crossConnects = dao.queryCrossConnectByLdpLsp(devID, ldpLsps);
                Collection asns = translator.encode(crossConnects, (IAsnTranslationContext)new AsnTranslationContext());
                rsp.lstLDPLspHopInfo.addAll(asns);
            }
            catch (VMFException e) {
                rsp.oResult.result = e.getErrorCode();
                this.getLogger().error("QueryLDPLspRouteTask failed!", (Throwable)e);
            }
        }
    }
}

