/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnLDPLspHopInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryLDPLspIngressRouteReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryLDPLspIngressRouteRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.mpls.model.CrossConnect;
import com.huawei.vmf.adapter.fservice.mpls.model.LdpLsp;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnLDPLspHopInfoTranslator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class QueryLDPLspIngressRouteTask
extends AbstractQTask<QAsnQueryLDPLspIngressRouteReq, QAsnQueryLDPLspIngressRouteRsp> {
    protected void executeTask(QAsnQueryLDPLspIngressRouteReq req, QAsnQueryLDPLspIngressRouteRsp rsp, Task task) {
        MplsDevDao dao = MplsDevDao.newInstance();
        rsp.oResult.result = 0;
        try {
            List<LdpLsp> ldpLsps = dao.queryLdpLsp(req.oTunnelKey.neID);
            Iterator<LdpLsp> iter = ldpLsps.iterator();
            while (iter.hasNext()) {
                LdpLsp mo = iter.next();
                if (LdpLsp.LSP_TYPE_ENUM.INGRESS.equals(mo.getLspType())) continue;
                iter.remove();
            }
            QAsnLDPLspHopInfoTranslator translator = new QAsnLDPLspHopInfoTranslator();
            Collection<CrossConnect> crossConnects = dao.queryCrossConnectByLdpLsp(req.oTunnelKey.neID, ldpLsps);
            for (CrossConnect crossConnect : crossConnects) {
                QAsnLDPLspHopInfo asn = (QAsnLDPLspHopInfo)translator.encode(crossConnect, (IAsnTranslationContext)new AsnTranslationContext());
                asn.iPosition = LdpLsp.LSP_TYPE_ENUM.INGRESS;
                rsp.lstLDPLspHopInfo.add((Object)asn);
            }
        }
        catch (VMFException e) {
            rsp.oResult.result = e.getErrorCode();
            this.getLogger().error("QueryLDPLspIngressRouteTask failed!", (Throwable)e);
        }
    }
}

