/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnInterfaceMplsInfoList;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryInterfaceMplsReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnQueryInterfaceMplsRsp;
import com.huawei.vmf.adapter.framework.service.QueryResult;
import com.huawei.vmf.adapter.framework.task.DefaultQueryByFDNTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.view.InterfaceMplsInfo;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.mpls.translation.asn.InterfaceMplsInfo2InterfaceMplsInfoTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QueryInterfaceMplsTask
extends DefaultQueryByFDNTask<QAsnQueryInterfaceMplsReq, QAsnQueryInterfaceMplsRsp, InterfaceMplsInfo> {
    private static final String ATM_TRUNK = "Atm-Trunk";
    private static final String AUX = "Aux";
    private static final String CPOS = "Cpos";
    private static final String DIALER = "Dialer";
    private static final String E1 = "E1";
    private static final String IN_LOOPBACK = "InLoopBack";
    private static final String LOGIC_CHANNEL = "Logic-Channel";
    private static final String LOOPBACK = "LoopBack";
    private static final String M_TUNNEL = "MTunnel";
    private static final String NULL = "NULL";
    private static final String RPR = "Rpr";
    private static final String TUNNEL = "Tunnel";

    public QueryInterfaceMplsTask(Collection<QAsnUniResID> fdns, QAsnInterfaceMplsInfoList queryResults, QAsnErrInfoReturn operResult) {
        super(fdns, (IFdnParser)new InterfaceFdnParser(), null, (IAsnTranslator)new InterfaceMplsInfo2InterfaceMplsInfoTranslator(), (Collection)queryResults, (FStruct)operResult, true, false);
    }

    protected InterfaceMplsInfo convertFilterMoFromFdnMo(VmfMO fdnMO) {
        if (null == fdnMO) {
            return null;
        }
        InterfaceMplsInfo mplsInterface = new InterfaceMplsInfo();
        Interface ifm = (Interface)fdnMO;
        mplsInterface.setDevID(ifm.getDevID());
        mplsInterface.setVrID(ifm.getVrID());
        mplsInterface.setInterfaceName(ifm.getIfName());
        mplsInterface.setFdn(ifm.getFdn());
        return mplsInterface;
    }

    protected void doExtendedProcAfterQuery(QAsnQueryInterfaceMplsReq req, QAsnQueryInterfaceMplsRsp rsp, QueryResult result) {
        ArrayList<Object> mos = result.getQueryResult(InterfaceMplsInfo.class);
        mos = null == mos ? new ArrayList<InterfaceMplsInfo>() : new ArrayList(mos);
        List originalFilterMOs = super.getFilterMos();
        if (!CollectionUtils.isEmpty(mos)) {
            HashMap<InterfaceMplsInfo, InterfaceMplsInfo> moInfos = new HashMap<InterfaceMplsInfo, InterfaceMplsInfo>();
            for (InterfaceMplsInfo mo : originalFilterMOs) {
                moInfos.put(mo, mo);
            }
            for (InterfaceMplsInfo mo : mos) {
                InterfaceMplsInfo findMO = (InterfaceMplsInfo)moInfos.get(mo);
                if (null == findMO) continue;
                mo.setFdn(findMO.getFdn());
            }
        }
        for (InterfaceMplsInfo mo : originalFilterMOs) {
            if (mos.contains(mo)) continue;
            mos.add(mo);
        }
    }

    protected List<InterfaceMplsInfo> getFilterMos() {
        ArrayList<InterfaceMplsInfo> usedFilterMos = new ArrayList<InterfaceMplsInfo>();
        for (InterfaceMplsInfo mo : super.getFilterMos()) {
            String ifName = mo.getInterfaceName();
            if (ifName.startsWith(DIALER) || ifName.startsWith(M_TUNNEL) || ifName.startsWith(E1) || ifName.startsWith(TUNNEL) || ifName.startsWith(NULL) || ifName.startsWith(LOGIC_CHANNEL) || ifName.startsWith(LOOPBACK) || ifName.startsWith(IN_LOOPBACK) || ifName.startsWith(AUX) || ifName.startsWith(RPR) || ifName.startsWith(ATM_TRUNK) || ifName.startsWith(CPOS)) {
                mo.setMplsCapability(Integer.valueOf(-1));
                continue;
            }
            mo.setMplsCapability(Integer.valueOf(0));
            usedFilterMos.add(mo);
        }
        return usedFilterMos;
    }
}

