/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyResult;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnClearOAMInfoReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnClearOAMInfoRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsOamTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.mpls.service.MplsOamTunnelService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class PtnClearOamInfoTask
extends AbstractConfigQTask<QAsnClearOAMInfoReq, QAsnClearOAMInfoRsp> {
    public PtnClearOamInfoTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(MplsOamTunnel.class, (ICompositeService)new MplsOamTunnelService());
    }

    protected void decode(QAsnClearOAMInfoReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        ArrayList<VmfMO> oamTunnels = new ArrayList<VmfMO>();
        MplsOamTunnelFdnParser fdnParser = new MplsOamTunnelFdnParser();
        for (Object tunnelKey : req.lstTunnelOAMKey) {
            QAsnUniResID resId = (QAsnUniResID)tunnelKey;
            oamTunnels.add(fdnParser.getIndexMo(resId));
        }
        Collection oamTunnelFromDB = null;
        try {
            oamTunnelFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamTunnel.class, oamTunnels, true);
        }
        catch (VMFException e) {
            this.getLogger().error("PtnClearOamInfoTask get oam tunnel info error");
        }
        Context context = asnTranslatorContext.getTransactionContext();
        IMOChangeRecord moChangeRecord = context.addChangeRecord(MplsOamTunnel.class);
        for (MplsOamTunnel oamTunnel : oamTunnelFromDB) {
            oamTunnel.setOamLossSd(Integer.valueOf(0));
            oamTunnel.setOamLossSf(Integer.valueOf(0));
            oamTunnel.setDetectMode(MplsOamTunnel.DETECT_MODE_ENUM.AUTO);
            oamTunnel.setDetectPktType(MplsOamTunnel.DETECT_PKT_TYPE_ENUM.CV);
            oamTunnel.setOamActiveState(MplsOamTunnel.OAM_ACTIVE_STATE_ENUM.DEACTIVE);
            oamTunnel.setDetectFrequence(MplsOamTunnel.DETECT_FREQUENCE_ENUM.INTERVAL1S);
            oamTunnel.setSendEnable(Boolean.FALSE);
            oamTunnel.setReceiveEnable(Boolean.FALSE);
            moChangeRecord.addModify((Object)oamTunnel, Arrays.asList("oamActiveState", "detectMode", "detectPktType", "detectFrequence", "oamLossSd", "oamLossSf", "receiveEnable"));
        }
    }

    protected void encode(QAsnClearOAMInfoRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Context context = asnTranslatorContext.getTransactionContext();
        OperResult operResult = context.getOperResult();
        IMOChangeRecord tunnelChangeRecord = context.getChangeRecord(MplsOamTunnel.class);
        Set oamTunnels = tunnelChangeRecord.getAllChanges();
        MplsOamTunnelFdnParser fdnParser = new MplsOamTunnelFdnParser();
        rsp.oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)oamTunnels, (OperResult)operResult);
        for (MplsOamTunnel oamTunnel : oamTunnels) {
            QAsnErrInfo tunnelErrInfo;
            QAsnUniResID uniResID;
            QAsnTunnelKeyResult qasnTunnelKeyResult = new QAsnTunnelKeyResult();
            rsp.lstTunnelOAMKey.add((Object)qasnTunnelKeyResult);
            qasnTunnelKeyResult.oTunnelKey = uniResID = fdnParser.getUniResID((VmfMO)oamTunnel);
            qasnTunnelKeyResult.result = tunnelErrInfo = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)oamTunnel, (OperResult)operResult);
        }
    }

    protected Integer getAsnBestEffort(QAsnClearOAMInfoReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnClearOAMInfoReq req) {
        return null;
    }
}

