/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRSVPTunnelInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnCreateRsvpTnlReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnModifyRsvpTnlRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractSingleMoConfigQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnRSVPTunnelInfoTranslator;
import java.util.Collection;
import java.util.Set;

public class ModifyRsvpTnlTask
extends AbstractSingleMoConfigQTask<QAsnCreateRsvpTnlReq, QAsnModifyRsvpTnlRsp, QAsnRSVPTunnelInfo, QAsnRSVPTunnelInfo, RsvpTeTunnel> {
    protected ModifyRsvpTnlTask() {
        super(RsvpTeTunnel.class, EOperationType.MODIFY, (IAsnTranslator)new QAsnRSVPTunnelInfoTranslator(), (IAsnTranslator)new QAsnRSVPTunnelInfoTranslator());
    }

    protected void encode(QAsnModifyRsvpTnlRsp rsp, IAsnTranslationContext context) {
        Set tunnels = context.getTransactionContext().getChangeRecord(RsvpTeTunnel.class).getModifies();
        OperResult operResult = context.getTransactionContext().getOperResult();
        rsp.oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)tunnels, (OperResult)operResult);
        try {
            RsvpTeTunnelFdnParser fdnParser = new RsvpTeTunnelFdnParser();
            for (RsvpTeTunnel tunnel : tunnels) {
                tunnel.setFdn(fdnParser.getFdn((VmfMO)tunnel));
                QAsnRSVPTunnelInfo asn = (QAsnRSVPTunnelInfo)this.getEncodeTranslator().encode((Object)tunnel, context);
                asn.oTunnelBase.poOperResult = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)tunnel, (OperResult)operResult);
                rsp.lstRSVPTunnelInfo.add((Object)asn);
            }
        }
        catch (VMFException e) {
            rsp.oResult.result = e.getErrorCode();
            this.getLogger().error("ModifyRsvpTnlTask encode failed!", (Throwable)e);
        }
    }

    protected Integer getAsnBestEffort(QAsnCreateRsvpTnlReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnCreateRsvpTnlReq req) {
        return req.strTaskFlag;
    }

    protected Collection<QAsnRSVPTunnelInfo> getDecodeAsns(QAsnCreateRsvpTnlReq req) {
        return req.lstRSVPTunnelInfo;
    }

    protected void setEncodeAsns(Collection<QAsnRSVPTunnelInfo> encodeAsns, QAsnModifyRsvpTnlRsp rsp, IAsnTranslationContext context) {
        rsp.lstRSVPTunnelInfo.addAll(encodeAsns);
    }
}

