/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingOAMInfo;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnModifySPRingOAMReq;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnModifySPRingOAMRsp;
import com.huawei.network.qasn.m_q_ip_tpoam_model.QAsnTPOamResKey;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.RingUniResIDParser;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsRingFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.Ring;
import com.huawei.vmf.adapter.fservice.tpoam.model.Meg;
import com.huawei.vmf.adapter.fservice.tpoam.service.ITpoamService;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.service.RingService;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnSPRingOAMBaseTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnSPRingOAMInfoTranslator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class ModifyRingOAMTask
extends AbstractConfigQTask<QAsnModifySPRingOAMReq, QAsnModifySPRingOAMRsp> {
    QAsnSPRingOAMBaseTranslator oamTranslator = new QAsnSPRingOAMBaseTranslator();
    QAsnSPRingOAMInfoTranslator oamInfoTranslator = new QAsnSPRingOAMInfoTranslator();
    private static final int OAM_MODE_1711 = 1;

    public ModifyRingOAMTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(Ring.class, (ICompositeService)new RingService());
    }

    public void execute(QAsnModifySPRingOAMReq req, QAsnModifySPRingOAMRsp rsp, Task task) {
        if (((QAsnSPRingOAMInfo)req.modifyOAMList.get((int)0)).oamInfo.mode == 1) {
            super.execute((FStruct)req, (FStruct)rsp, task);
            rsp.modifyOAMList = req.modifyOAMList;
        } else {
            this.switchRingOamToTpOam(req);
            ITpoamService tpoamService = Activator.getService(ITpoamService.class);
            try {
                tpoamService.modifyRingY1731(req.modifyOAMList);
                QAsnErrInfoReturn result = new QAsnErrInfoReturn();
                result.result = 0;
                result.errList = new QAsnErrInfoList();
                rsp.result = result;
                rsp.modifyOAMList = req.modifyOAMList;
            }
            catch (VMFException e) {
                this.getLogger().error("ModifyRingOAMTask modifyTpOam failed!", (Throwable)e);
            }
        }
    }

    protected void decode(QAsnModifySPRingOAMReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        if (CollectionUtils.isEmpty((Collection)req.modifyOAMList)) {
            return;
        }
        for (int i = 0; i < req.modifyOAMList.size(); ++i) {
            QAsnSPRingOAMInfo asnOamInfo = (QAsnSPRingOAMInfo)req.modifyOAMList.get(i);
            Ring ring = new Ring();
            try {
                ring.setDevID(Integer.valueOf(asnOamInfo.sprFDN.neID));
                this.oamInfoTranslator.decode(asnOamInfo, ring, asnTranslatorContext);
                this.oamTranslator.decode(asnOamInfo.oamInfo, ring, asnTranslatorContext);
                this.decodeRingFdn(new String(asnOamInfo.sprFDN.strFDN), ring);
                IMOChangeRecord recordRing = asnTranslatorContext.getTransactionContext().addChangeRecord(Ring.class);
                recordRing.addModify((Object)ring, Arrays.asList("detectFrequence", "detectPktType", "oamActiveState", "oamLossSd", "oamLossSf", "ringDirection", "ringId"));
                continue;
            }
            catch (VMFException e) {
                this.getLogger().error("ModifyRingOAMTask decode failed!", (Throwable)e);
            }
        }
    }

    protected void encode(QAsnModifySPRingOAMRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        QAsnErrInfoReturn oResult;
        Context context = asnTranslatorContext.getTransactionContext();
        OperResult operResult = context.getOperResult();
        Set mos = context.getChangeRecord(Meg.class).getAllChanges();
        rsp.result = oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)mos, (OperResult)operResult);
    }

    protected Integer getAsnBestEffort(QAsnModifySPRingOAMReq req) {
        return 1;
    }

    protected byte[] getAsnTaskFlag(QAsnModifySPRingOAMReq req) {
        return "".getBytes();
    }

    public void decodeRingFdn(String strFDN, Ring ring) {
        RingUniResIDParser ringRes = new RingUniResIDParser();
        ringRes.deserialize(strFDN);
        ring.setRingId(BigInteger.valueOf(ringRes.getRingID()));
    }

    private void switchRingOamToTpOam(QAsnModifySPRingOAMReq modifyOamReq) {
        int len = modifyOamReq.modifyOAMList.size();
        for (int i = 0; i < len; ++i) {
            QAsnSPRingOAMInfo ringOam = (QAsnSPRingOAMInfo)modifyOamReq.modifyOAMList.get(i);
            int neOam = MplsUtil.getOamType(ringOam.sprFDN);
            int configOam = ringOam.oamInfo.mode;
            if (1 != neOam || 2 != configOam) continue;
            QAsnTPOamResKey key = new QAsnTPOamResKey();
            key.oResKey = ringOam.sprFDN;
            ErrorInfo errorInfo = MplsUtil.switchRing(key, ringOam.direction);
            if (!this.isSuccess(errorInfo)) continue;
            this.deleteOam(key, ringOam.direction);
        }
    }

    private void deleteOam(QAsnTPOamResKey resKey, int direction) {
        MplsRingFdnParser ringfdnParser = new MplsRingFdnParser();
        MplsRing ring = (MplsRing)ringfdnParser.getIndexMo(resKey.oResKey);
        Ring ringOam = new Ring();
        ringOam.setDevID(ring.getDevID());
        ringOam.setVrID(ring.getVrID());
        ringOam.setFdn(ring.getFdn());
        ringOam.setRingId(BigInteger.valueOf(ring.getRingId().intValue()));
        ringOam.setRingDirection(Integer.valueOf(direction));
        ArrayList<Ring> ringMos = new ArrayList<Ring>();
        ringMos.add(ringOam);
        try {
            Collection dbRingOAMMos = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(Ring.class, ringMos, false);
            if (!CollectionUtils.isEmpty((Collection)dbRingOAMMos)) {
                Context ctx = new Context();
                IMOChangeRecord record = ctx.addChangeRecord(Ring.class);
                record.addDelete(dbRingOAMMos);
                MplsDao.newInstance(ctx).merge(Ring.class, false);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("after switch to 1731 then delete ring Oam failed!", (Throwable)e);
        }
    }
}

