/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnPwOamAttr;
import com.huawei.network.qasn.m_q_ip_pwe3_model.QAsnPwe3ModifyPwOam;
import com.huawei.network.qasn.m_q_ip_pwe3_op.QAsnModifyPwOamReq;
import com.huawei.network.qasn.m_q_ip_pwe3_op.QAsnModifyPwOamRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamPw;
import com.huawei.vmf.adapter.fservice.pwe3.service.IPwe3Service;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.task.ConfigOamPwInfoForModifyDBTask;
import com.huawei.vmf.adapter.mpls.task.ConfigOamPwInfoForModifyTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class ModifyPwOAMTask
extends AbstractQTask<QAsnModifyPwOamReq, QAsnModifyPwOamRsp> {
    protected void executeTask(QAsnModifyPwOamReq req, QAsnModifyPwOamRsp rsp, Task task) {
        try {
            for (Object qasnPwOAMInfo : req.pwOamInfoList) {
                QAsnPwe3ModifyPwOam asnPwOAMInfo = (QAsnPwe3ModifyPwOam)qasnPwOAMInfo;
                QAsnPwOamAttr asnPwOAMAttrInfo = asnPwOAMInfo.newPwOamAttr;
                QAsnUniResID pwOAMInfoKey = asnPwOAMInfo.pwKey;
                Collection<MplsOamPw> oamResults = MplsDao.newInstance().queryPwOAMByQAsnUniResID(pwOAMInfoKey);
                boolean exitsFlag = !oamResults.isEmpty();
                IPwe3Service pwe3Service = Activator.getService(IPwe3Service.class);
                ArrayList<String> fdnList = new ArrayList<String>();
                fdnList.add(new String(pwOAMInfoKey.strFDN));
                Map pwDeployStatus = pwe3Service.queryVpwsPwDeployStatusByPwFdn(fdnList);
                if (CollectionUtils.isEmpty((Map)pwDeployStatus)) {
                    this.getLogger().info("ModifyPwOAMTask queryVpwsPwDeployStatusByPwFdn result isempty. FDN:" + new String(pwOAMInfoKey.strFDN));
                    continue;
                }
                Integer deployStatus = (Integer)pwDeployStatus.get(new String(pwOAMInfoKey.strFDN));
                if (deployStatus == 1 && exitsFlag) {
                    ConfigOamPwInfoForModifyTask configDeployTask = new ConfigOamPwInfoForModifyTask(asnPwOAMAttrInfo, new String(pwOAMInfoKey.strFDN));
                    configDeployTask.execute((FStruct)req, (FStruct)rsp, task);
                    continue;
                }
                ConfigOamPwInfoForModifyDBTask configCreatTask = new ConfigOamPwInfoForModifyDBTask(asnPwOAMAttrInfo, new String(pwOAMInfoKey.strFDN));
                configCreatTask.execute((FStruct)req, (FStruct)rsp, task);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("ConfigOAMInfoTask executeTask failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.result, (VMFException)e);
        }
    }
}

