/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelPGInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelPGInfoList;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnModifyProtectionGroupReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnModifyProtectionGroupRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelGroup;
import com.huawei.vmf.adapter.mpls.service.TunnelGroupService;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelPGInfoTranslator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class ModifyProtectionGroupTask
extends AbstractConfigQTask<QAsnModifyProtectionGroupReq, QAsnModifyProtectionGroupRsp> {
    private Logger logger = RunLogger.getLogger(ModifyProtectionGroupTask.class);
    private Map<TunnelGroup, QAsnTunnelPGInfo> tpgInfoAsnMap = new HashMap<TunnelGroup, QAsnTunnelPGInfo>();

    protected ModifyProtectionGroupTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(TunnelGroup.class, (ICompositeService)new TunnelGroupService());
    }

    protected void decode(QAsnModifyProtectionGroupReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        QAsnTunnelPGInfoList decodeAsns = req.lstProtectionGroupInfo;
        try {
            for (QAsnTunnelPGInfo decodeAsn : decodeAsns) {
                TunnelGroup tunnelMO = new TunnelGroup();
                QAsnTunnelPGInfoTranslator translator = new QAsnTunnelPGInfoTranslator();
                translator.decode(decodeAsn, tunnelMO, asnTranslatorContext);
                this.tpgInfoAsnMap.put(tunnelMO, decodeAsn);
            }
        }
        catch (VMFException e) {
            this.logger.error("decode req error. decodeAsns=" + decodeAsns, (Throwable)e);
        }
    }

    protected void encode(QAsnModifyProtectionGroupRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Context context = asnTranslatorContext.getTransactionContext();
        IMOChangeRecord tunnelGPChangeRecord = context.getChangeRecord(TunnelGroup.class);
        OperResult operResult = context.getOperResult();
        Set tunnelGPs = tunnelGPChangeRecord.getAllChanges();
        rsp.oReturn = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)tunnelGPs, (OperResult)operResult);
        for (TunnelGroup tunnelGP : tunnelGPs) {
            QAsnTunnelPGInfo asnTunnelPGInfo = this.tpgInfoAsnMap.get(tunnelGP);
            asnTunnelPGInfo.poOperResult = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)tunnelGP, (OperResult)operResult);
            rsp.lstProtectionGroupInfo.add((Object)asnTunnelPGInfo);
        }
    }

    protected Integer getAsnBestEffort(QAsnModifyProtectionGroupReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnModifyProtectionGroupReq req) {
        return req.strTaskFlag;
    }
}

