/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnExpath;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnExpathResult;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnModifyExPathReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnModifyExPathRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractSingleMoConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPath;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPathHop;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnExpathResultTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnExpathTranslator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class ModifyExPathTask
extends AbstractSingleMoConfigQTask<QAsnModifyExPathReq, QAsnModifyExPathRsp, QAsnExpath, QAsnExpathResult, ExplicitPath> {
    private static String TEMP_KEY_SEPARATOR = "/";

    protected ModifyExPathTask() {
        super(ExplicitPath.class, EOperationType.MODIFY, (IAsnTranslator)new QAsnExpathTranslator(), (IAsnTranslator)new QAsnExpathResultTranslator());
    }

    protected void decode(QAsnModifyExPathReq req, Task task, IAsnTranslationContext context) {
        Collection<QAsnExpath> decodeAsns = this.getDecodeAsns(req);
        MplsDao dao = MplsDao.newInstance();
        try {
            Collection explicitPaths = this.getDecodeTranslator().decode(decodeAsns, context);
            Collection dbExplicitPaths = dao.queryByKey(ExplicitPath.class, explicitPaths, true);
            HashMap<String, ExplicitPath> dbPathMap = new HashMap<String, ExplicitPath>();
            for (ExplicitPath path : dbExplicitPaths) {
                dbPathMap.put(this.getExplicitPathTempKey(path), path);
            }
            for (ExplicitPath path : explicitPaths) {
                String key = this.getExplicitPathTempKey(path);
                ExplicitPath dbPath = (ExplicitPath)dbPathMap.get(key);
                if (dbPath == null) continue;
                this.comparePath(path, dbPath, context);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("decode req error. decodeAsns=" + decodeAsns, (Throwable)e);
        }
    }

    protected void encode(QAsnModifyExPathRsp rsp, IAsnTranslationContext context) {
        Context transactionContext = context.getTransactionContext();
        Set explicitPaths = transactionContext.getChangeRecord(ExplicitPath.class).getModifies();
        OperResult operResult = transactionContext.getOperResult();
        rsp.oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)explicitPaths, (OperResult)operResult);
        try {
            for (ExplicitPath explicitPath : explicitPaths) {
                QAsnExpathResult asn = (QAsnExpathResult)this.getEncodeTranslator().encode((Object)explicitPath, context);
                asn.oResult = AsnTranslatorUtil.getMoQAsnSingleReturn((VmfMO)explicitPath, (OperResult)operResult);
                rsp.lstResult.add((Object)asn);
            }
        }
        catch (VMFException e) {
            rsp.oResult.result = 1107499878;
            this.getLogger().error("ModifyExPathTask encode failed!", (Throwable)e);
        }
    }

    protected Integer getAsnBestEffort(QAsnModifyExPathReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnModifyExPathReq req) {
        return req.strTaskFlag;
    }

    protected Collection<QAsnExpath> getDecodeAsns(QAsnModifyExPathReq req) {
        return req.lstExpath;
    }

    protected void setEncodeAsns(Collection<QAsnExpathResult> encodeAsns, QAsnModifyExPathRsp rsp, IAsnTranslationContext context) {
    }

    private void comparePath(ExplicitPath path, ExplicitPath dbPath, IAsnTranslationContext context) {
        boolean isEmptyHop = CollectionUtils.isEmpty((Collection)path.getExplicitPathHops());
        boolean isEmptyDbHop = CollectionUtils.isEmpty((Collection)dbPath.getExplicitPathHops());
        if (isEmptyHop && isEmptyDbHop) {
            return;
        }
        Context transactionContext = context.getTransactionContext();
        IMOChangeRecord pathRecord = transactionContext.getChangeRecord(ExplicitPath.class);
        IMOChangeRecord hopRecord = transactionContext.getChangeRecord(ExplicitPathHop.class);
        pathRecord.addModify((Object)path, new PropertyChangeItem(ExplicitPathHop.class.getName()));
        if (isEmptyHop && !isEmptyDbHop) {
            hopRecord.addDelete(dbPath.getExplicitPathHops());
            return;
        }
        if (!isEmptyHop && isEmptyDbHop) {
            hopRecord.addCreate(path.getExplicitPathHops());
            return;
        }
        HashMap<String, Long> dbAddrIndexMap = new HashMap<String, Long>();
        HashMap<Long, ExplicitPathHop> dbHopMap = new HashMap<Long, ExplicitPathHop>();
        for (ExplicitPathHop hop : dbPath.getExplicitPathHops()) {
            dbAddrIndexMap.put(hop.getMplsTunnelHopIpAddr(), hop.getMplsTunnelHopIndex());
            dbHopMap.put(hop.getMplsTunnelHopIndex(), hop);
        }
        for (ExplicitPathHop hop : path.getExplicitPathHops()) {
            Long index = hop.getMplsTunnelHopIndex();
            ExplicitPathHop dbHop = (ExplicitPathHop)dbHopMap.get(index);
            if (dbHop == null) {
                hopRecord.addCreate((Object)hop);
                continue;
            }
            boolean isSameAddr = ObjectUtils.equals((Object)hop.getMplsTunnelHopIpAddr(), (Object)dbHop.getMplsTunnelHopIpAddr());
            if (isSameAddr) {
                boolean isSameHopType = ObjectUtils.equals((Object)hop.getMplsTunnelHopType(), (Object)dbHop.getMplsTunnelHopType());
                if (!isSameHopType) {
                    hopRecord.addModify((Object)hop, new PropertyChangeItem("mplsTunnelHopType"));
                }
            } else {
                hopRecord.addDelete((Object)hop);
                hopRecord.addCreate((Object)hop);
            }
            dbHopMap.remove(index);
        }
        for (ExplicitPathHop dbHop : dbHopMap.values()) {
            path.getExplicitPathHops().add(dbHop);
            hopRecord.addDelete((Object)dbHop);
        }
    }

    private String getExplicitPathTempKey(ExplicitPath explicitPath) {
        StringBuilder sb = new StringBuilder();
        sb.append(explicitPath.getDevID());
        sb.append(TEMP_KEY_SEPARATOR);
        sb.append(explicitPath.getVrID());
        sb.append(TEMP_KEY_SEPARATOR);
        sb.append(explicitPath.getExplicitPathName());
        return sb.toString();
    }
}

