/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnUseableMplsLabel;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnGetUseableMplsLabelReq;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnGetUseableMplsLabelRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsStaticLabelSeg;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnUseableMplsLabelTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class GetUseableMplsLabelTask
extends AbstractQTask<QAsnGetUseableMplsLabelReq, QAsnGetUseableMplsLabelRsp> {
    private static final int SIZE_OF_CHAR = 8;
    private static final int RADIX_2 = 2;
    private Map<String, byte[]> maskMap = new HashMap<String, byte[]>();

    protected void executeTask(QAsnGetUseableMplsLabelReq req, QAsnGetUseableMplsLabelRsp rsp, Task task) {
        QAsnUseableMplsLabelTranslator translator = new QAsnUseableMplsLabelTranslator();
        AsnTranslationContext context = new AsnTranslationContext();
        context.setTransactionContext(new Context());
        Collection labelSegs = null;
        try {
            labelSegs = translator.decode((Collection)req.ringLabelList, (IAsnTranslationContext)context);
        }
        catch (VMFException e) {
            this.getLogger().error("GetUseableMplsLabelTask decode failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
            return;
        }
        try {
            for (MplsStaticLabelSeg labelSeg : labelSegs) {
                List<Long> freeLabels = MplsDevDao.newInstance().queryFreeLabel(labelSeg);
                if (CollectionUtils.isEmpty(freeLabels)) continue;
                byte[] mask = this.calMask(labelSeg, freeLabels);
                String key = labelSeg.getDevID() + "|" + labelSeg.getLabelBegin() + "|" + labelSeg.getLabelEnd();
                this.getLogger().error("GetUseableMplsLabelTask getMaskMap. key = " + key + " ,and mask length = " + mask.length);
                this.maskMap.put(key, mask);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("GetUseableMplsLabelTask query from dev failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
            return;
        }
        try {
            Collection asns = translator.encode(labelSegs, (IAsnTranslationContext)context);
            for (QAsnUseableMplsLabel label : asns) {
                String key = label.neID + "|" + label.first + "|" + label.last;
                if (null != this.maskMap.get(key)) {
                    label.mask = this.maskMap.get(key);
                    continue;
                }
                this.getLogger().error("GetUseableMplsLabelTask getMaskMap Key do not find, key = " + key);
            }
            rsp.ringLabelList.addAll(asns);
            rsp.oResult.result = 0;
        }
        catch (VMFException e) {
            this.getLogger().error("VMFException encode failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
        }
    }

    private byte[] calMask(MplsStaticLabelSeg labelSeg, List<Long> freeLabels) {
        int begin = labelSeg.getLabelBegin().intValue();
        int maxLength = labelSeg.getLabelEnd().intValue() - labelSeg.getLabelBegin().intValue() + 1;
        StringBuilder sb = new StringBuilder();
        for (long i = 0L; i < (long)maxLength; ++i) {
            sb.append(freeLabels.contains((long)begin + i) ? 0 : 1);
        }
        String content = sb.toString();
        sb = new StringBuilder();
        ArrayList<Byte> byteArray = new ArrayList<Byte>();
        for (int i = 0; i < maxLength; i += 8) {
            int end = i + 8;
            int charInt = Integer.valueOf(content.substring(i, end), 2);
            byteArray.add((byte)charInt);
        }
        byte[] result = new byte[byteArray.size()];
        for (int i = 0; i < byteArray.size(); ++i) {
            result[i] = (Byte)byteArray.get(i);
        }
        return result;
    }

    private static class LabelUseable {
        private static final int USEABLE = 0;
        private static final int UNUSEABLE = 1;

        private LabelUseable() {
        }
    }
}

