/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetUseTunnelIDReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetUseTunnelIDRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class GetUseTunnelIDTask
extends AbstractQTask<QAsnGetUseTunnelIDReq, QAsnGetUseTunnelIDRsp> {
    private static final String MY_COMMA = ",";
    private static final String RANGE_TO = "-";

    protected void executeTask(QAsnGetUseTunnelIDReq req, QAsnGetUseTunnelIDRsp rsp, Task task) {
        rsp.result.isSuccess = true;
        rsp.result.retCode = 0;
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            Collection tunnels = dao.queryByNeID(RsvpTeTunnel.class, Arrays.asList(req.neID), false);
            if (CollectionUtils.isEmpty((Collection)tunnels)) {
                return;
            }
            ArrayList<Integer> tunnelIDs = new ArrayList<Integer>();
            for (RsvpTeTunnel tnl : tunnels) {
                if (null == tnl.getMplsTunnelIndex()) continue;
                tunnelIDs.add(tnl.getMplsTunnelIndex());
            }
            Collections.sort(tunnelIDs, new Comparator<Integer>(){

                @Override
                public int compare(Integer arg0, Integer arg1) {
                    return arg0 - arg1;
                }
            });
            rsp.strTunnelID = StringUtil.globalByte((String)this.intList2Range(tunnelIDs));
        }
        catch (VMFException e) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = e.getErrorCode();
            this.getLogger().error("exception", (Throwable)e);
        }
    }

    private String intList2Range(List<Integer> vec) {
        int index;
        if (vec.isEmpty()) {
            return "";
        }
        StringBuilder ss = new StringBuilder();
        int sz = vec.size();
        for (int pos = 0; pos < sz; pos += index) {
            int begin = vec.get(pos);
            index = 1;
            while (index + pos < sz && begin + index == vec.get(index + pos)) {
                ++index;
            }
            ss.append(MY_COMMA).append(begin);
            if (index <= 1) continue;
            ss.append(RANGE_TO).append(begin + index - 1);
        }
        String str = ss.toString();
        if (!str.isEmpty()) {
            return str.substring(1);
        }
        return "";
    }
}

