/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetTunnelReverseLspReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetTunnelReverseLspRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.ReverseRsvpTeLsp;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelReverseLspInfoTranslator;
import java.util.ArrayList;
import java.util.Collection;

public class GetTunnelReverseLspTask
extends AbstractQTask<QAsnGetTunnelReverseLspReq, QAsnGetTunnelReverseLspRsp> {
    protected void executeTask(QAsnGetTunnelReverseLspReq req, QAsnGetTunnelReverseLspRsp rsp, Task task) {
        ArrayList<ReverseRsvpTeLsp> conditions = new ArrayList<ReverseRsvpTeLsp>();
        RsvpTeTunnelFdnParser fdnParser = new RsvpTeTunnelFdnParser();
        for (Object resObj : req.lstTunnelKey) {
            RsvpTeTunnel mo = (RsvpTeTunnel)fdnParser.getIndexMo((QAsnUniResID)resObj);
            ReverseRsvpTeLsp reverseRsvpTeLsp = new ReverseRsvpTeLsp();
            reverseRsvpTeLsp.setDevID(mo.getDevID());
            reverseRsvpTeLsp.setTunnelName(mo.getTunnelName());
            reverseRsvpTeLsp.setVrID(mo.getVrID());
            conditions.add(reverseRsvpTeLsp);
        }
        Collection tunnels = null;
        try {
            tunnels = MplsDao.newInstance().queryByKey(ReverseRsvpTeLsp.class, conditions, false);
        }
        catch (VMFException e) {
            this.getLogger().error("GetTunnelReverseLspTask query failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
            return;
        }
        QAsnTunnelReverseLspInfoTranslator translator = new QAsnTunnelReverseLspInfoTranslator();
        try {
            Collection asns = translator.encode(tunnels, (IAsnTranslationContext)new AsnTranslationContext());
            rsp.lstTunnelKey.addAll(asns);
            rsp.oResult.result = 0;
        }
        catch (VMFException e) {
            this.getLogger().error("GetTunnelReverseLspTask encode failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
        }
    }
}

