/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnDevIDAndNumPair;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnDistributionResult;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelIfAndIDPair;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetTunnelIfAndIDByDevIDReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetTunnelIfAndIDByDevIDRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class GetTunnelIfAndIDByDevIDTask
extends AbstractQTask<QAsnGetTunnelIfAndIDByDevIDReq, QAsnGetTunnelIfAndIDByDevIDRsp> {
    private static final int DEVID_INDEX = 0;
    private static final int MAX_TUNNEL_INDEX = 65535;
    private static final int MAX_TUNNEL_NAME_INT = 65535;
    private static final int MIN_TUNNEL_INDEX = 1;
    private static final int MIN_TUNNEL_NAME_INT = 1;
    private static final String TUNNEL_INTER_TYPE = "Tunnel";
    private static final int TUNNEL_NUM_INDEX = 2;
    private static Map<Integer, Integer> tunnelIndexCache = new HashMap<Integer, Integer>();
    private static Map<Integer, Integer> tunnelNameNumCache = new HashMap<Integer, Integer>();
    private static final int VRID_INDEX = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCache() {
        Map<Integer, Integer> map = tunnelIndexCache;
        synchronized (map) {
            tunnelIndexCache.clear();
        }
        map = tunnelNameNumCache;
        synchronized (map) {
            tunnelNameNumCache.clear();
        }
    }

    protected void executeTask(QAsnGetTunnelIfAndIDByDevIDReq req, QAsnGetTunnelIfAndIDByDevIDRsp rsp, Task task) {
        try {
            int[][] devIDAndVrIDs = new int[req.lstDevIDAndNumPair.size()][];
            ArrayList<RsvpTeTunnel> conditions = new ArrayList<RsvpTeTunnel>();
            for (int i = 0; i < req.lstDevIDAndNumPair.size(); ++i) {
                QAsnDevIDAndNumPair asn = (QAsnDevIDAndNumPair)req.lstDevIDAndNumPair.get(i);
                int vrId = null == asn.poVrID ? 0 : asn.poVrID;
                devIDAndVrIDs[i] = new int[]{asn.neID, vrId, asn.iNum};
                RsvpTeTunnel tunnel = new RsvpTeTunnel();
                tunnel.setDevID(Integer.valueOf(asn.neID));
                conditions.add(tunnel);
            }
            MplsDao dao = MplsDao.newInstance();
            Collection tunnels = dao.queryByKey(RsvpTeTunnel.class, conditions, false);
            Map<Integer, List<RsvpTeTunnel>> tunnelMap = this.groupTunnelsByDevId(tunnels);
            this.distribute(rsp, devIDAndVrIDs, tunnelMap);
        }
        catch (VMFException e) {
            this.getLogger().error("QAsnGetTunnelIfAndIDByDevIDReq exception.", (Throwable)e);
            rsp.oResult.result = 1107499878;
            QAsnErrInfo error = new QAsnErrInfo();
            error.errCode = e.getErrorCode();
        }
    }

    private void distribute(QAsnGetTunnelIfAndIDByDevIDRsp rsp, int[][] devIDAndVrIDs, Map<Integer, List<RsvpTeTunnel>> tunnelMap) {
        rsp.oResult.result = 0;
        for (int i = 0; i < devIDAndVrIDs.length; ++i) {
            int devId = devIDAndVrIDs[i][0];
            int vrId = devIDAndVrIDs[i][1];
            int num = devIDAndVrIDs[i][2];
            List<RsvpTeTunnel> tunnels = tunnelMap.get(devId);
            List<String> tunnelNames = this.distributeTunnelInterfaces(devId, tunnels, num);
            List<Integer> tunnelIndexs = this.distributeTunnelIndexs(devId, tunnels, num);
            QAsnDistributionResult asnResult = new QAsnDistributionResult();
            asnResult.neID = devId;
            asnResult.poVrID = vrId;
            if (tunnelNames.size() < num || tunnelIndexs.size() < num) {
                asnResult.oResult = new QAsnErrInfo();
                asnResult.oResult.errCode = 1107499878;
                rsp.oResult.result = 1107499878;
                rsp.lstDistributionResult.add((Object)asnResult);
                break;
            }
            for (int k = 0; k < num; ++k) {
                String tunnelName = tunnelNames.get(k);
                Integer tunnelIndex = tunnelIndexs.get(k);
                QAsnTunnelIfAndIDPair pair = new QAsnTunnelIfAndIDPair();
                pair.strTunnelIfName = StringUtil.globalByte((String)tunnelName);
                pair.iTunnelID = tunnelIndex;
                asnResult.lstTunnelIfAndIDPair.add((Object)pair);
            }
            asnResult.oResult.errCode = 0;
            rsp.lstDistributionResult.add((Object)asnResult);
        }
    }

    private List<Integer> distributeTunnelIndexs(int devId, List<RsvpTeTunnel> tunnels, int num) {
        int begin;
        ArrayList<Integer> tunnelIndexs = new ArrayList<Integer>();
        int maxIndex = this.findMaxTunnelIndex(devId, tunnels, num);
        for (int i = begin = Math.max(1, maxIndex + 1); i <= 65535 && num > 0; --num, ++i) {
            tunnelIndexs.add(i);
        }
        if (num == 0) {
            return tunnelIndexs;
        }
        HashSet<Integer> tunnelIndexSet = new HashSet<Integer>();
        if (!CollectionUtils.isEmpty(tunnels)) {
            for (RsvpTeTunnel tunnel : tunnels) {
                tunnelIndexSet.add(tunnel.getMplsTunnelIndex());
            }
        }
        for (int i = 1; i <= 65535 && num > 0; ++i) {
            Integer tmpTunnelIndex = i;
            if (tunnelIndexSet.contains(tmpTunnelIndex)) continue;
            tunnelIndexs.add(tmpTunnelIndex);
            --num;
        }
        return tunnelIndexs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> distributeTunnelInterfaces(int devId, List<RsvpTeTunnel> tunnels, int num) {
        String name;
        int i;
        HashSet<String> tunnelNameSet = new HashSet<String>();
        int minNum = 1;
        if (!CollectionUtils.isEmpty(tunnels)) {
            for (RsvpTeTunnel tunnel : tunnels) {
                String tunnelName = tunnel.getTunnelName();
                tunnelNameSet.add(tunnelName);
                if (!tunnelName.matches("Tunnel\\d+")) continue;
                minNum = Math.max(minNum, Integer.parseInt(tunnelName.substring(TUNNEL_INTER_TYPE.length())) + 1);
            }
        }
        Map<Integer, Integer> i$ = tunnelNameNumCache;
        synchronized (i$) {
            Integer tunnelNum = tunnelNameNumCache.get(devId);
            if (tunnelNum == null) {
                tunnelNameNumCache.put(devId, minNum + num);
            } else {
                minNum = tunnelNum;
                tunnelNameNumCache.put(devId, tunnelNum + num);
            }
        }
        ArrayList<String> tunnelNames = new ArrayList<String>();
        for (i = minNum; i <= 65535 && num > 0; ++i) {
            name = TUNNEL_INTER_TYPE + i;
            if (tunnelNameSet.contains(name)) continue;
            tunnelNames.add(name);
            tunnelNameSet.add(name);
            --num;
        }
        if (num == 0) {
            return tunnelNames;
        }
        for (i = 1; i <= 65535 && num > 0; ++i) {
            name = TUNNEL_INTER_TYPE + i;
            if (tunnelNameSet.contains(name)) continue;
            tunnelNames.add(name);
            --num;
        }
        return tunnelNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findMaxTunnelIndex(int devId, List<RsvpTeTunnel> tunnels, int num) {
        int max = 0;
        if (!CollectionUtils.isEmpty(tunnels)) {
            for (RsvpTeTunnel tunnel : tunnels) {
                if (null == tunnel.getMplsTunnelIndex()) continue;
                max = Math.max(max, tunnel.getMplsTunnelIndex());
            }
        }
        Map<Integer, Integer> map = tunnelIndexCache;
        synchronized (map) {
            Integer maxCache = tunnelIndexCache.get(devId);
            if (maxCache == null || max > maxCache) {
                tunnelIndexCache.put(devId, max + num);
            } else {
                max = maxCache;
                tunnelIndexCache.put(devId, maxCache + num);
            }
        }
        return max;
    }

    private Map<Integer, List<RsvpTeTunnel>> groupTunnelsByDevId(Collection<RsvpTeTunnel> tunnels) {
        HashMap<Integer, List<RsvpTeTunnel>> map = new HashMap<Integer, List<RsvpTeTunnel>>();
        if (CollectionUtils.isEmpty(tunnels)) {
            return map;
        }
        for (RsvpTeTunnel tunnel : tunnels) {
            Integer devId = tunnel.getDevID();
            ArrayList<RsvpTeTunnel> tmpTunnels = (ArrayList<RsvpTeTunnel>)map.get(devId);
            if (tmpTunnels == null) {
                tmpTunnels = new ArrayList<RsvpTeTunnel>();
                map.put(tunnel.getDevID(), tmpTunnels);
            }
            tmpTunnels.add(tunnel);
        }
        return map;
    }
}

