/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnGetSPRingInterfaceReq;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnGetSPRingInterfaceRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.service.IInterfaceService;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsInterface;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnSPRingIfBaseInfoTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class GetSPRingInterfaceTask
extends AbstractQTask<QAsnGetSPRingInterfaceReq, QAsnGetSPRingInterfaceRsp> {
    private static final int NEMPLS_FILTER_ALL_ONQUERYIF = 2;
    private static final String ETH_INTERFACE = "Ethernet";
    private static final String GE_INTERFACE = "GE";

    protected void executeTask(QAsnGetSPRingInterfaceReq req, QAsnGetSPRingInterfaceRsp rsp, Task task) {
        if (CollectionUtils.isEmpty((Collection)req.lstNeID)) {
            return;
        }
        List<Integer> devIds = this.parseDevIds(req);
        Collection<Interface> supportMplsIfms = null;
        try {
            supportMplsIfms = MplsDao.newInstance().querySupportMplsInterfaces(devIds, true);
        }
        catch (VMFException e) {
            this.getLogger().error("GetSPRingInterfaceTask querySupportMplsInterfaces failed! ", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
            return;
        }
        Collection mplsIfms = null;
        try {
            mplsIfms = MplsDao.newInstance().queryByNeID(MplsInterface.class, devIds, true);
        }
        catch (VMFException e) {
            this.getLogger().error("GetSPRingInterfaceTask query MplsInterface failed! ", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
            return;
        }
        this.bindMplsInterface(supportMplsIfms, mplsIfms);
        this.filterIfmsByReq(req, supportMplsIfms);
        IInterfaceService service = Activator.getService(IInterfaceService.class);
        service.loadInterfaceWithBoard(supportMplsIfms);
        this.encodeResult(rsp, supportMplsIfms);
    }

    private void encodeResult(QAsnGetSPRingInterfaceRsp rsp, Collection<Interface> supportMplsIfms) {
        if (MplsUtil.isPtn()) {
            Iterator<Interface> iter = supportMplsIfms.iterator();
            while (iter.hasNext()) {
                boolean isEthIf;
                Interface inter = iter.next();
                if (!inter.isDeployed()) {
                    iter.remove();
                    continue;
                }
                boolean bl = isEthIf = -1 != inter.getIfName().indexOf(ETH_INTERFACE) || -1 != inter.getIfName().indexOf(GE_INTERFACE);
                if (InterfaceUtil.isMainInterface((String)inter.getIfName()) || isEthIf) continue;
                iter.remove();
            }
        }
        QAsnSPRingIfBaseInfoTranslator translator = new QAsnSPRingIfBaseInfoTranslator();
        AsnTranslationContext context = new AsnTranslationContext();
        Context ctx = new Context();
        context.setTransactionContext(ctx);
        rsp.oResult.result = 0;
        try {
            Collection asns = translator.encode(supportMplsIfms, (IAsnTranslationContext)context);
            rsp.ifBaseList.addAll(asns);
        }
        catch (VMFException e) {
            this.getLogger().error("GetSPRingInterfaceTask encode failed! ", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
        }
    }

    private List<Integer> parseDevIds(QAsnGetSPRingInterfaceReq req) {
        ArrayList<Integer> devIds = new ArrayList<Integer>(req.lstNeID.size());
        for (Object devIdObj : req.lstNeID) {
            Integer devId = (Integer)devIdObj;
            devIds.add(devId);
        }
        return devIds;
    }

    private void filterIfmsByReq(QAsnGetSPRingInterfaceReq req, Collection<Interface> supportMplsIfms) {
        Iterator<Interface> iter = supportMplsIfms.iterator();
        while (iter.hasNext()) {
            Interface supportMplsIfm = iter.next();
            int mplsStatus = 2;
            int mplsTeStatus = 2;
            MplsInterface mifm = null;
            List mifms = supportMplsIfm.getKeyRefMos(MplsInterface.class);
            if (CollectionUtils.isEmpty((Collection)mifms)) {
                mplsStatus = 0;
            } else {
                mplsStatus = 1;
                mifm = (MplsInterface)mifms.iterator().next();
                int n = mplsTeStatus = mifm.getMplsTEEnable() == null || mifm.getMplsTEEnable() == false ? 1 : 0;
            }
            if ((req.iMplsStatus == 2 || mplsStatus == req.iMplsStatus) && (req.iMplsTeStatus == 2 || mplsTeStatus == req.iMplsTeStatus)) continue;
            iter.remove();
        }
    }

    private void bindMplsInterface(Collection<Interface> supportMplsIfms, Collection<MplsInterface> mplsIfms) {
        HashMap<String, Interface> ifmMap = new HashMap<String, Interface>();
        InterfaceFdnParser fdnParser = new InterfaceFdnParser();
        for (Interface supportMplsIfm : supportMplsIfms) {
            String fdn = fdnParser.getFdn((VmfMO)supportMplsIfm);
            ifmMap.put(fdn, supportMplsIfm);
        }
        for (MplsInterface mplsIfm : mplsIfms) {
            Interface ifm = MplsUtil.translate2Interface(mplsIfm);
            String fdn = fdnParser.getFdn((VmfMO)ifm);
            Interface supportMplsIfm = (Interface)ifmMap.get(fdn);
            if (supportMplsIfm == null) continue;
            supportMplsIfm.addKeyRefMo((VmfMO)mplsIfm);
        }
    }
}

