/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnNEOperatorResult;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnGetSPRingByNeIDReq;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnGetSPRingByNeIDRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnSPRingInfoTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnSPRingVirtualNodeTranslator;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;

public class GetSPRingByNeIDTask
extends AbstractQTask<QAsnGetSPRingByNeIDReq, QAsnGetSPRingByNeIDRsp> {
    protected void executeTask(QAsnGetSPRingByNeIDReq req, QAsnGetSPRingByNeIDRsp rsp, Task task) {
        MplsDao dao = MplsDao.newInstance();
        Collection mplsRings = null;
        try {
            mplsRings = dao.queryByNeID(MplsRing.class, (Collection)req.neIDList, true);
            dao.loadMplsRingOamInfo(mplsRings);
        }
        catch (VMFException e) {
            this.getLogger().error("GetSPRingByNeIDTask query failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
            return;
        }
        try {
            this.encodeRingList(rsp, mplsRings);
            this.encodeVirtualNodeList(rsp, mplsRings);
        }
        catch (VMFException e) {
            this.getLogger().error("GetSPRingByNeIDTask encode failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
            return;
        }
        this.encodeResult(req, rsp);
    }

    private void encodeRingList(QAsnGetSPRingByNeIDRsp rsp, Collection<MplsRing> mplsRings) throws VMFException {
        QAsnSPRingInfoTranslator translator = new QAsnSPRingInfoTranslator();
        AsnTranslationContext context = new AsnTranslationContext();
        Context ctx = new Context();
        context.setTransactionContext(ctx);
        rsp.ringList.addAll(translator.encode(mplsRings, (IAsnTranslationContext)context));
    }

    private void encodeVirtualNodeList(QAsnGetSPRingByNeIDRsp rsp, Collection<MplsRing> mplsRings) throws VMFException {
        ArrayList nodes = new ArrayList();
        for (MplsRing mplsRing : mplsRings) {
            Collection ringNodes = mplsRing.getRingMapVirtualNodes();
            if (CollectionUtils.isEmpty((Collection)ringNodes)) continue;
            nodes.addAll(ringNodes);
        }
        QAsnSPRingVirtualNodeTranslator translator = new QAsnSPRingVirtualNodeTranslator();
        AsnTranslationContext context = new AsnTranslationContext();
        Context ctx = new Context();
        context.setTransactionContext(ctx);
        rsp.virtualNodeList.addAll(translator.encode(nodes, (IAsnTranslationContext)context));
    }

    private void encodeResult(QAsnGetSPRingByNeIDReq req, QAsnGetSPRingByNeIDRsp rsp) {
        for (Object asn : req.neIDList) {
            Integer devId = (Integer)asn;
            QAsnNEOperatorResult asnResult = new QAsnNEOperatorResult();
            asnResult.neID = devId;
            asnResult.oResult.errCode = 0;
            rsp.neResultList.add((Object)asnResult);
        }
        rsp.oResult.result = 0;
    }
}

