/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRouteLsp;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetRouterReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetRouterRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.Lsp;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnRouteLspTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class GetRouterTask
extends AbstractQTask<QAsnGetRouterReq, QAsnGetRouterRsp> {
    protected void executeTask(QAsnGetRouterReq req, QAsnGetRouterRsp rsp, Task task) {
        rsp.oResult.result = 0;
        List<RsvpTeTunnel> tunnels = this.parseTunnels(req);
        try {
            MplsDevDao.newInstance().loadTunneLsps(tunnels);
            List<Lsp> lsps = this.getLspsFromTunnels(tunnels);
            QAsnRouteLspTranslator translator = new QAsnRouteLspTranslator();
            Collection asns = translator.encode(lsps, (IAsnTranslationContext)new AsnTranslationContext());
            for (QAsnRouteLsp asn : asns) {
                asn.poOperResult = new QAsnErrInfo();
                asn.poOperResult.errCode = 0;
            }
            this.postEncodeLspType(asns);
            rsp.lstLsp.addAll(asns);
        }
        catch (VMFException e) {
            rsp.oResult.result = 1107499878;
            this.getLogger().error("GetRouterTask failed!", (Throwable)e);
        }
    }

    protected List<RsvpTeTunnel> parseTunnels(QAsnGetRouterReq req) {
        ArrayList<RsvpTeTunnel> tunnels = new ArrayList<RsvpTeTunnel>();
        RsvpTeTunnelFdnParser fdnParser = new RsvpTeTunnelFdnParser();
        for (Object obj : req.lstTunnelKey) {
            QAsnUniResID resId = (QAsnUniResID)obj;
            RsvpTeTunnel tunnel = (RsvpTeTunnel)fdnParser.getIndexMo(resId);
            tunnels.add(tunnel);
        }
        return tunnels;
    }

    private List<Lsp> getLspsFromTunnels(List<RsvpTeTunnel> tunnels) {
        ArrayList<Lsp> lspList = new ArrayList<Lsp>();
        for (RsvpTeTunnel tunnel : tunnels) {
            Collection lsps = tunnel.getLsps();
            if (CollectionUtils.isEmpty((Collection)lsps)) continue;
            for (Lsp lsp : lsps) {
                lsp.addKeyRefMo((VmfMO)tunnel);
                if (tunnel.getWorkingLspId() == lsp.getMplsTunnelInstance()) {
                    lsp.setCurrentLsp(true);
                    continue;
                }
                lsp.setCurrentLsp(false);
            }
            lspList.addAll(tunnel.getLsps());
        }
        return lspList;
    }

    private void postEncodeLspType(Collection<QAsnRouteLsp> asns) {
        if (CollectionUtils.isEmpty(asns)) {
            return;
        }
        boolean hasPrimary = false;
        boolean hasSecondary = false;
        for (QAsnRouteLsp asn : asns) {
            if (asn.iTnlLspType == 1) {
                hasPrimary = true;
                continue;
            }
            if (asn.iTnlLspType != 2) continue;
            hasSecondary = true;
        }
        if (!hasPrimary && hasSecondary) {
            for (QAsnRouteLsp asn : asns) {
                if (asn.iTnlLspType != 2) continue;
                asn.iTnlLspType = 1;
            }
        }
    }
}

