/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnExpath;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnPreviewRSVPTnlRouteParam;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnPreviewRSVPTnlRouteParamList;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnPreviewRSVPTnlRouteResult;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnPreviewRSVPTnlRouteResultList;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRSVPTnlPreviewRoute;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRSVPTnlPreviewRouteList;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetRSVPTnlPreviewRouteReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetRSVPTnlPreviewRouteRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.mpls.model.CspfPreCalc;
import com.huawei.vmf.adapter.fservice.mpls.model.CspfPreCalchop;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPath;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnExpathTranslator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class GetRSVPTnlPreviewRouteTask
extends AbstractQTask<QAsnGetRSVPTnlPreviewRouteReq, QAsnGetRSVPTnlPreviewRouteRsp> {
    private static Comparator<CspfPreCalchop> cspfPreCalchopComparator = new Comparator<CspfPreCalchop>(){

        @Override
        public int compare(CspfPreCalchop hop1, CspfPreCalchop hop2) {
            return (int)(hop1.getHopIndex() - hop2.getHopIndex());
        }
    };
    private static BigInteger PREVIEW_BACKUP = BigInteger.valueOf(1L);

    protected void executeTask(QAsnGetRSVPTnlPreviewRouteReq req, QAsnGetRSVPTnlPreviewRouteRsp rsp, Task task) {
        Context context = null;
        try {
            context = this.createPreExPath(req.lstPreviewTnlParam);
        }
        catch (VMFException e) {
            this.getLogger().error("GetRSVPTnlPreviewRouteTask createPreExPath failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
            return;
        }
        Collection<CspfPreCalc> calcs = this.parseCspfPreCalc(req.lstPreviewTnlParam);
        try {
            MplsDevDao.newInstance().loadCspfPreCalchops(calcs);
            rsp.lstPreviewTnlResult = this.encode(calcs);
            rsp.oResult.result = 0;
        }
        catch (VMFException e) {
            this.getLogger().error("GetRSVPTnlPreviewRouteTask query lsp failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
        }
        try {
            this.deletePreExPath(context);
        }
        catch (VMFException e) {
            this.getLogger().error("GetRSVPTnlPreviewRouteTask deletePreExPath failed!", (Throwable)e);
        }
    }

    private Map<String, List<CspfPreCalc>> assortCalcsBySn(Collection<CspfPreCalc> calcs) {
        HashMap<String, List<CspfPreCalc>> calcMap = new HashMap<String, List<CspfPreCalc>>();
        for (CspfPreCalc calc : calcs) {
            String strSn = calc.getStrSn();
            ArrayList<CspfPreCalc> snCalcs = (ArrayList<CspfPreCalc>)calcMap.get(strSn);
            if (snCalcs == null) {
                snCalcs = new ArrayList<CspfPreCalc>();
                calcMap.put(strSn, snCalcs);
            }
            snCalcs.add(calc);
        }
        return calcMap;
    }

    private Context createPreExPath(QAsnPreviewRSVPTnlRouteParamList lstPreviewTnlParam) throws VMFException {
        Context context = new Context();
        if (CollectionUtils.isEmpty((Collection)lstPreviewTnlParam)) {
            return context;
        }
        HashSet<QAsnExpath> expathAsns = new HashSet<QAsnExpath>();
        for (QAsnPreviewRSVPTnlRouteParam param : lstPreviewTnlParam) {
            if (param.poMainPath != null) {
                expathAsns.add(param.poMainPath);
            }
            if (param.poBackupPath == null) continue;
            expathAsns.add(param.poBackupPath);
        }
        if (CollectionUtils.isEmpty(expathAsns)) {
            return context;
        }
        QAsnExpathTranslator translator = new QAsnExpathTranslator();
        AsnTranslationContext asnCcontext = new AsnTranslationContext();
        asnCcontext.setTransactionContext(context);
        Collection paths = translator.decode(expathAsns, (IAsnTranslationContext)asnCcontext);
        IMOChangeRecord record = context.addChangeRecord(ExplicitPath.class);
        record.addCreate(paths);
        DefaultCompositeService service = new DefaultCompositeService(ExplicitPath.class);
        service.create(context);
        return context;
    }

    private void deletePreExPath(Context context) throws VMFException {
        IMOChangeRecord record = context.addChangeRecord(ExplicitPath.class);
        ArrayList paths = new ArrayList(record.getCreates());
        record.clear();
        record.addDelete(paths);
        DefaultCompositeService service = new DefaultCompositeService(ExplicitPath.class);
        service.delete(context);
    }

    private QAsnPreviewRSVPTnlRouteResultList encode(Collection<CspfPreCalc> calcs) {
        Map<String, List<CspfPreCalc>> calcMap = this.assortCalcsBySn(calcs);
        QAsnPreviewRSVPTnlRouteResultList lspResultList = new QAsnPreviewRSVPTnlRouteResultList();
        for (Map.Entry<String, List<CspfPreCalc>> entry : calcMap.entrySet()) {
            String strSn = entry.getKey();
            List<CspfPreCalc> snCalcs = entry.getValue();
            QAsnPreviewRSVPTnlRouteResult lspResult = new QAsnPreviewRSVPTnlRouteResult();
            lspResult.strSn = AsnUtil.getBytes((String)strSn);
            lspResult.oResult.result = 0;
            for (CspfPreCalc calc : snCalcs) {
                Collection hops = calc.getCspfPreCalchops();
                if (CollectionUtils.isEmpty((Collection)hops)) continue;
                ArrayList sortHops = new ArrayList(hops);
                Collections.sort(sortHops, cspfPreCalchopComparator);
                QAsnRSVPTnlPreviewRouteList previewRouteList = null;
                previewRouteList = "BACKUP".equals(calc.getPathType()) ? lspResult.lstBackupPathPreviewRoute : lspResult.lstMainPathPreviewRoute;
                long serialNum = 0L;
                for (CspfPreCalchop hop : sortHops) {
                    String hopIpAddress = hop.getHopIpAddress();
                    previewRouteList.add((Object)this.getQAsnRSVPTnlPreviewRoute(hopIpAddress, serialNum, BigInteger.valueOf(hop.getHopAddrType().intValue())));
                    ++serialNum;
                }
                if (!"MAIN_BACKUP".equals(calc.getPathType())) continue;
                lspResult.lstBackupPathPreviewRoute.addAll((Collection)previewRouteList);
            }
            lspResultList.add((Object)lspResult);
        }
        return lspResultList;
    }

    private String getExPathName(QAsnExpath asn) {
        if (asn != null && asn.oExpathKey != null && asn.oExpathKey.strExpathName != null) {
            return AsnUtil.strValue((byte[])asn.oExpathKey.strExpathName);
        }
        return null;
    }

    private QAsnRSVPTnlPreviewRoute getQAsnRSVPTnlPreviewRoute(String ip, long hopIndex, BigInteger ipType) {
        QAsnRSVPTnlPreviewRoute asn = new QAsnRSVPTnlPreviewRoute();
        asn.strIPAddress = AsnUtil.getBytes((String)ip);
        asn.iRouteSerialNum = BigInteger.valueOf(hopIndex);
        asn.iIPType = ipType;
        return asn;
    }

    private Collection<CspfPreCalc> parseCspfPreCalc(QAsnPreviewRSVPTnlRouteParamList previewTnlParam) {
        if (CollectionUtils.isEmpty((Collection)previewTnlParam)) {
            return null;
        }
        ArrayList<CspfPreCalc> calcs = new ArrayList<CspfPreCalc>();
        for (QAsnPreviewRSVPTnlRouteParam param : previewTnlParam) {
            String mainPath = this.getExPathName(param.poMainPath);
            CspfPreCalc mainCalc = new CspfPreCalc();
            mainCalc.setDevID(Integer.valueOf(param.neID));
            mainCalc.setVrID(Integer.valueOf(0));
            mainCalc.setDestination(AsnUtil.strValue((byte[])param.strDestination));
            mainCalc.setStrSn(AsnUtil.strValue((byte[])param.strSn));
            if (!StringUtil.isEmpty((String)mainPath)) {
                mainCalc.setExplicitPathName(mainPath);
            }
            mainCalc.setPathType("MAIN");
            calcs.add(mainCalc);
            if (!PREVIEW_BACKUP.equals(param.iIsPreviewBackup)) continue;
            String backupPath = this.getExPathName(param.poBackupPath);
            if (ObjectUtils.equals((Object)mainPath, (Object)backupPath)) {
                mainCalc.setPathType("MAIN_BACKUP");
                continue;
            }
            CspfPreCalc backupCalc = new CspfPreCalc();
            backupCalc.setDevID(Integer.valueOf(param.neID));
            backupCalc.setVrID(Integer.valueOf(0));
            backupCalc.setDestination(AsnUtil.strValue((byte[])param.strDestination));
            backupCalc.setStrSn(AsnUtil.strValue((byte[])param.strSn));
            if (!StringUtil.isEmpty((String)backupPath)) {
                backupCalc.setExplicitPathName(backupPath);
            }
            backupCalc.setPathType("BACKUP");
            calcs.add(backupCalc);
        }
        return calcs;
    }

    private static class PathType {
        private static final String BACKUP = "BACKUP";
        private static final String MAIN = "MAIN";
        private static final String MAIN_BACKUP_SAME = "MAIN_BACKUP";

        private PathType() {
        }
    }
}

