/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetOamStatusReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetOamStatusRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsOamTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnOamStatusTranslator;
import java.util.ArrayList;
import java.util.Collection;

public class GetOamStatusTask
extends AbstractQTask<QAsnGetOamStatusReq, QAsnGetOamStatusRsp> {
    protected void executeTask(QAsnGetOamStatusReq req, QAsnGetOamStatusRsp rsp, Task task) {
        MplsOamTunnelFdnParser fdnParser = new MplsOamTunnelFdnParser();
        ArrayList<MplsOamTunnel> mos = new ArrayList<MplsOamTunnel>(req.lstTunnelKey.size());
        for (Object resObj : req.lstTunnelKey) {
            mos.add((MplsOamTunnel)fdnParser.getIndexMo((QAsnUniResID)resObj));
        }
        try {
            MplsDevDao.newInstance().syncOamStatus(mos);
        }
        catch (VMFException e) {
            this.getLogger().error("QueryTnlRunStatusFromNETask syncTunnelStatus failed!", (Throwable)e);
            rsp.oResult.result = e.getErrorCode();
            return;
        }
        QAsnOamStatusTranslator translator = new QAsnOamStatusTranslator();
        AsnTranslationContext context = new AsnTranslationContext();
        context.setTransactionContext(new Context());
        try {
            Collection asns = translator.encode(mos, (IAsnTranslationContext)context);
            rsp.lstOamStatus.addAll(asns);
            rsp.oResult.result = 0;
        }
        catch (VMFException e) {
            this.getLogger().error("QueryTnlRunStatusFromNETask encode failed!", (Throwable)e);
            rsp.oResult.result = e.getErrorCode();
        }
    }
}

