/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnUseableMplsLabel;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnGetNeMplsLabelRangeReq;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnGetNeMplsLabelRangeRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsLabelStatistic;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import java.util.ArrayList;
import java.util.Collection;

public class GetNeMplsLabelRangeTask
extends AbstractQTask<QAsnGetNeMplsLabelRangeReq, QAsnGetNeMplsLabelRangeRsp> {
    protected void executeTask(QAsnGetNeMplsLabelRangeReq req, QAsnGetNeMplsLabelRangeRsp rsp, Task task) {
        Collection<MplsLabelStatistic> segList = null;
        try {
            segList = MplsDevDao.newInstance().queryMplsStaticLabelSegById((Collection<Integer>)req.neIDList);
        }
        catch (VMFException e) {
            this.getLogger().error("GetNeMplsLabelRangeTask query form dev failed!", (Throwable)e);
            AsnTranslatorUtil.addRspResultError((QAsnErrInfoReturn)rsp.oResult, (VMFException)e);
            return;
        }
        ArrayList<QAsnUseableMplsLabel> asns = new ArrayList<QAsnUseableMplsLabel>();
        for (MplsLabelStatistic label : segList) {
            QAsnUseableMplsLabel asn = new QAsnUseableMplsLabel();
            asn.first = label.getMinValue().intValue();
            asn.last = label.getMaxValue().intValue();
            asn.mask = "".getBytes();
            asn.neID = label.getDevID();
            asns.add(asn);
        }
        rsp.ringSwitchList.addAll(asns);
        rsp.oResult.result = 0;
    }
}

