/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnIGPRouteBaseInfo;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnIPAddrPair;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnISISRouteProcessInfo;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnISISRouteProcessInfoList;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnOSPFRouteProcessInfo;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnOSPFRouteProcessInfoList;
import com.huawei.network.qasn.m_q_ip_common_op.QAsnGetNeIGPRouteBaseInfoReq;
import com.huawei.network.qasn.m_q_ip_common_op.QAsnGetNeIGPRouteBaseInfoRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.fservice.mpls.model.IsisTE;
import com.huawei.vmf.adapter.fservice.mpls.model.OspfTE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;

public class GetNeIGPRouteBaseInfoTask
extends AbstractQTask<QAsnGetNeIGPRouteBaseInfoReq, QAsnGetNeIGPRouteBaseInfoRsp> {
    private IDao dao = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null);
    private Logger logger = RunLogger.getLogger(GetNeIGPRouteBaseInfoTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask(QAsnGetNeIGPRouteBaseInfoReq req, QAsnGetNeIGPRouteBaseInfoRsp rsp, Task task) {
        rsp.oResult.result = 0;
        ArrayList<Integer> devIDLst = new ArrayList<Integer>();
        for (Object ipAddrPair : req.lstLsrNodeIDPair) {
            devIDLst.add(((QAsnIPAddrPair)ipAddrPair).neID);
        }
        try {
            Collection isisTEList = this.dao.queryByNeID(IsisTE.class, devIDLst, true);
            Collection ospfTEList = this.dao.queryByNeID(OspfTE.class, devIDLst, true);
            HashMap<Integer, QAsnIGPRouteBaseInfo> mapDevRouteInfo = new HashMap<Integer, QAsnIGPRouteBaseInfo>();
            for (IsisTE isisTE : isisTEList) {
                int devID = isisTE.getDevID();
                QAsnIGPRouteBaseInfo igpRouteInfo = (QAsnIGPRouteBaseInfo)mapDevRouteInfo.get(devID);
                if (null == igpRouteInfo) {
                    igpRouteInfo = new QAsnIGPRouteBaseInfo();
                    igpRouteInfo.neID = devID;
                    mapDevRouteInfo.put(devID, igpRouteInfo);
                    rsp.lstIGPRouteBaseInfo.add((Object)igpRouteInfo);
                }
                QAsnISISRouteProcessInfo isisRouteInfo = new QAsnISISRouteProcessInfo();
                isisRouteInfo.iProcessID = AsnUtil.bigIntegerValue((Long)isisTE.getProcessID());
                isisRouteInfo.iISISLevel = AsnUtil.bigIntegerValue((Long)isisTE.getIntLevel());
                if (null == igpRouteInfo.poLstISISProcessInfo) {
                    igpRouteInfo.poLstISISProcessInfo = new QAsnISISRouteProcessInfoList();
                }
                igpRouteInfo.poLstISISProcessInfo.add((Object)isisRouteInfo);
            }
            HashMap<Long, QAsnOSPFRouteProcessInfo> mapProcessArea = new HashMap<Long, QAsnOSPFRouteProcessInfo>();
            for (OspfTE ospfTE : ospfTEList) {
                QAsnOSPFRouteProcessInfo ospfRouterInfo;
                int devID = ospfTE.getDevID();
                QAsnIGPRouteBaseInfo igpRouteInfo = (QAsnIGPRouteBaseInfo)mapDevRouteInfo.get(devID);
                if (null == igpRouteInfo) {
                    igpRouteInfo = new QAsnIGPRouteBaseInfo();
                    igpRouteInfo.neID = devID;
                    mapDevRouteInfo.put(devID, igpRouteInfo);
                    rsp.lstIGPRouteBaseInfo.add((Object)igpRouteInfo);
                }
                if (null == (ospfRouterInfo = (QAsnOSPFRouteProcessInfo)mapProcessArea.get(ospfTE.getProcessID()))) {
                    ospfRouterInfo = new QAsnOSPFRouteProcessInfo();
                    ospfRouterInfo.iProcessID = AsnUtil.bigIntegerValue((Long)ospfTE.getProcessID());
                    mapProcessArea.put(ospfTE.getProcessID(), ospfRouterInfo);
                    if (null == igpRouteInfo.poLstOSPFProcessInfo) {
                        igpRouteInfo.poLstOSPFProcessInfo = new QAsnOSPFRouteProcessInfoList();
                    }
                    igpRouteInfo.poLstOSPFProcessInfo.add((Object)ospfRouterInfo);
                }
                ospfRouterInfo.lstAreaNum.add((Object)AsnUtil.getBytes((String)ospfTE.getArea()));
            }
        }
        catch (VMFException e) {
            this.logger.error("GetNeIGPRouteBaseInfoTask executeTask Failed!", (Throwable)e);
            rsp.oResult.result = e.getErrorCode();
        }
        finally {
            this.dao.rollback();
        }
    }
}

