/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetMplsInOutIfReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetMplsInOutIfRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsInterface;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnMplsIfBaseInfoTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class GetMplsInOutIfTask
extends AbstractQTask<QAsnGetMplsInOutIfReq, QAsnGetMplsInOutIfRsp> {
    private static final int MPLS_STATUS_ALL = 2;
    private static final int MPLS_STATUS_DISABLE = 0;
    private static final int MPLS_STATUS_ENABLE = 1;
    private static final int MPLS_TE_STATUS_ALL = 2;
    private static final int MPLS_TE_STATUS_ENABLE = 1;
    private static final String MAIN_CONTROL_INTERFACE = "Ethernet0/0/0";
    private static final String NULL_INTERFACE = "NULL";
    private static final String GLOBAL_VE = "Global-VE";
    private static final String ETH_INTERFACE = "Ethernet";
    private static final String GE_INTERFACE = "GE";

    protected void executeTask(QAsnGetMplsInOutIfReq req, QAsnGetMplsInOutIfRsp rsp, Task task) {
        ArrayList<Integer> devIdList = new ArrayList<Integer>();
        for (Object id : req.lstNeID) {
            devIdList.add((Integer)id);
        }
        int mplsTeStatus = req.iMplsTeStatus;
        int mplsStatus = req.iMplsStatus;
        rsp.oResult.result = 0;
        if (mplsStatus == 2) {
            Collection<MplsInterface> mplsInterfaceList = this.queryMplsInterface(devIdList, mplsTeStatus, rsp.oResult);
            if (rsp.oResult.result != 0) {
                return;
            }
            Collection<Interface> interfaceList = this.queryInterface(devIdList, rsp.oResult);
            if (rsp.oResult.result != 0) {
                this.setMplsInterfaces2Rsp(mplsInterfaceList, rsp);
                return;
            }
            mplsInterfaceList = this.unionInterfaces(mplsInterfaceList, interfaceList);
            this.setMplsInterfaces2Rsp(mplsInterfaceList, rsp);
        } else if (mplsStatus == 1) {
            Collection<MplsInterface> mplsInterfaceList = this.queryMplsInterface(devIdList, mplsTeStatus, rsp.oResult);
            if (rsp.oResult.result != 0) {
                return;
            }
            this.setMplsInterfaces2Rsp(mplsInterfaceList, rsp);
        } else if (mplsStatus == 0) {
            if (mplsTeStatus == 1) {
                return;
            }
            Collection<Interface> interfaceList = this.queryInterface(devIdList, rsp.oResult);
            if (rsp.oResult.result != 0) {
                return;
            }
            List<MplsInterface> mplsInterfaceList = this.translateIfs2Mif(interfaceList);
            this.setMplsInterfaces2Rsp(mplsInterfaceList, rsp);
        }
    }

    private Collection<Interface> queryInterface(List<Integer> devIdList, QAsnErrInfoReturn oResult) {
        try {
            MplsDao dao = MplsDao.newInstance();
            return dao.queryMplsAbleInterfaces(devIdList);
        }
        catch (VMFException e) {
            oResult.result = e.getErrorCode();
            this.getLogger().error("query Interface failed!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Collection<MplsInterface> queryMplsInterface(List<Integer> devIdList, int mplsTeStatus, QAsnErrInfoReturn result) {
        MplsDao dao = MplsDao.newInstance();
        try {
            if (2 == mplsTeStatus) {
                return dao.queryByNeID(MplsInterface.class, devIdList, true);
            }
            ArrayList<MplsInterface> conditions = new ArrayList<MplsInterface>();
            MplsInterface mif = new MplsInterface();
            mif.setMplsTEEnable(Boolean.valueOf(1 == mplsTeStatus));
            conditions.add(mif);
            String[] fieldNames = new String[]{"mplsTEEnable"};
            return dao.queryByNeID(MplsInterface.class, devIdList, fieldNames, conditions, true);
        }
        catch (VMFException e) {
            result.result = e.getErrorCode();
            this.getLogger().error("query MplsInterface failed!", (Throwable)e);
            return null;
        }
    }

    private void setMplsInterfaces2Rsp(Collection<MplsInterface> mplsInterfaceList, QAsnGetMplsInOutIfRsp rsp) {
        if (CollectionUtils.isEmpty(mplsInterfaceList)) {
            return;
        }
        if (MplsUtil.isPtn()) {
            Iterator<MplsInterface> iter = mplsInterfaceList.iterator();
            while (iter.hasNext()) {
                boolean isEthIf;
                String interfaceName = iter.next().getInterfaceName();
                boolean bl = isEthIf = !InterfaceUtil.isMainInterface((String)interfaceName) && (-1 != interfaceName.indexOf(ETH_INTERFACE) || -1 != interfaceName.indexOf(GE_INTERFACE));
                if (!InterfaceUtil.isMainInterface((String)interfaceName) && !isEthIf) {
                    iter.remove();
                    continue;
                }
                if (-1 == interfaceName.indexOf(MAIN_CONTROL_INTERFACE) && -1 == interfaceName.indexOf(NULL_INTERFACE) && -1 == interfaceName.indexOf(GLOBAL_VE)) continue;
                iter.remove();
            }
        }
        QAsnMplsIfBaseInfoTranslator translator = new QAsnMplsIfBaseInfoTranslator();
        try {
            Collection asns = translator.encode(mplsInterfaceList, null);
            rsp.lstInterfaceBase.addAll(asns);
        }
        catch (VMFException e) {
            rsp.oResult.result = e.getErrorCode();
            this.getLogger().error("translate MplsInterface to QAsnMplsIfBaseInfo fail", (Throwable)e);
        }
    }

    private MplsInterface translateIf2Mif(Interface inter) {
        InterfaceFdnParser fdnParser = new InterfaceFdnParser();
        MplsInterface mif = new MplsInterface();
        mif.setDevID(inter.getDevID());
        mif.setFdn(fdnParser.getFdn(inter));
        mif.setVrID(inter.getVrID());
        mif.setInterfaceName(inter.getIfName());
        mif.setLdpEnable(Boolean.valueOf(false));
        mif.setMplsTEEnable(Boolean.valueOf(false));
        mif.setRsvpTEEnable(Boolean.valueOf(false));
        mif.addKeyRefMo((VmfMO)inter);
        return mif;
    }

    private List<MplsInterface> translateIfs2Mif(Collection<Interface> interfaceList) {
        ArrayList<MplsInterface> mifList = new ArrayList<MplsInterface>();
        for (Interface inter : interfaceList) {
            if (!inter.isDeployed()) continue;
            MplsInterface mif = this.translateIf2Mif(inter);
            mifList.add(mif);
        }
        return mifList;
    }

    private Collection<MplsInterface> unionInterfaces(Collection<MplsInterface> mplsInterfaceList, Collection<Interface> interfaceList) {
        if (CollectionUtils.isEmpty(interfaceList)) {
            return mplsInterfaceList;
        }
        List<MplsInterface> mifList = this.translateIfs2Mif(interfaceList);
        if (CollectionUtils.isEmpty(mplsInterfaceList)) {
            return mifList;
        }
        HashMap<String, MplsInterface> mplsIfmMap = new HashMap<String, MplsInterface>();
        for (MplsInterface ifm : mplsInterfaceList) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{ifm.getDevID(), ifm.getVrID(), ifm.getInterfaceName()});
            mplsIfmMap.put(key, ifm);
        }
        ArrayList<MplsInterface> resultList = new ArrayList<MplsInterface>();
        for (MplsInterface ifm : mifList) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{ifm.getDevID(), ifm.getVrID(), ifm.getInterfaceName()});
            MplsInterface mplsIfm = (MplsInterface)mplsIfmMap.get(key);
            if (mplsIfm == null) {
                ifm.addKeyRefMo((VmfMO)ifm);
                resultList.add(ifm);
                continue;
            }
            mplsIfm.addKeyRefMos((Collection)ifm.getKeyRefMos(Interface.class));
            resultList.add(mplsIfm);
        }
        return resultList;
    }
}

