/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnNEIDList;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRouteHop;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRouteLsp;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnRouteTunnel;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetBypassTunnelReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnGetBypassTunnelRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsCommonCfg;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeLsp;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeLspARHop;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnLspKey2RsvpTeLspTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class GetBypassTunnelTask
extends AbstractQTask<QAsnGetBypassTunnelReq, QAsnGetBypassTunnelRsp> {
    public static final int IN_IF = 1;
    public static final int LSR_ID = 2;
    private static final int BINDING_TNL_IF_NAME = 1;
    private static final int HOP_TYPE_MOD = 3;
    private static final int OUT_IF = 0;

    protected void executeTask(QAsnGetBypassTunnelReq req, QAsnGetBypassTunnelRsp rsp, Task task) {
        rsp.oResult.result = 0;
        RsvpTeLsp filterLspMO = new RsvpTeLsp();
        try {
            filterLspMO = (RsvpTeLsp)new QAsnLspKey2RsvpTeLspTranslator().decode((FStruct)req.oLspKey, null);
        }
        catch (VMFException e) {
            this.getLogger().error("GetBypassTunnelTask decode failed!");
            rsp.oResult.result = 1107499878;
            return;
        }
        List<RsvpTeLsp> bypassTunnelNames = null;
        try {
            bypassTunnelNames = this.getBypassTunnelNamesFromDev(req.lstNeID, filterLspMO, rsp.oResult);
        }
        catch (VMFException e) {
            this.getLogger().error("getBypassTunnelNamesFromDev failed!", (Throwable)e);
            rsp.oResult.result = e.getErrorCode();
            return;
        }
        this.queryBypassRoutes(bypassTunnelNames, req, rsp);
    }

    private List<RsvpTeLsp> getBypassTunnelNamesFromDev(QAsnNEIDList devIDList, RsvpTeLsp filterLspMO, QAsnErrInfoReturn result) throws VMFException {
        ArrayList<RsvpTeLsp> filterMOs = new ArrayList<RsvpTeLsp>();
        for (Object devID : devIDList) {
            RsvpTeLsp LspKey = new RsvpTeLsp();
            LspKey.setMplsTunnelIngressLSRId(filterLspMO.getMplsTunnelIngressLSRId());
            LspKey.setMplsSessionID(filterLspMO.getMplsSessionID());
            LspKey.setMplsTunnelInstance(filterLspMO.getMplsTunnelInstance());
            LspKey.setDevID((Integer)devID);
            filterMOs.add(LspKey);
        }
        List<String> queryFieldNames = Arrays.asList("bypassTunnelName", "mplsTunnelEgressLSRId");
        Map<Integer, Collection<RsvpTeLsp>> results = this.queryRsvpTeLspFromDev(filterMOs, result, queryFieldNames);
        if (CollectionUtils.isEmpty(results)) {
            return Collections.emptyList();
        }
        ArrayList<RsvpTeLsp> bypassTunnelNames = new ArrayList<RsvpTeLsp>();
        for (Map.Entry<Integer, Collection<RsvpTeLsp>> queryResult : results.entrySet()) {
            String bypassTunnelName;
            if (CollectionUtils.isEmpty(queryResult.getValue()) || StringUtil.isEmpty((String)(bypassTunnelName = queryResult.getValue().iterator().next().getTunnelName()))) continue;
            RsvpTeLsp bypassLsp = new RsvpTeLsp();
            bypassLsp.setTunnelName(bypassTunnelName);
            bypassLsp.setDevID(queryResult.getKey());
            bypassTunnelNames.add(bypassLsp);
        }
        return bypassTunnelNames;
    }

    private Map<Integer, String> getLsrIdByDevids(Set<Integer> devIds) throws VMFException {
        MplsDao dao = MplsDao.newInstance();
        Collection cfgs = dao.queryByNeID(MplsCommonCfg.class, devIds, false);
        HashMap<Integer, String> lsrIds = new HashMap<Integer, String>();
        for (MplsCommonCfg cfg : cfgs) {
            lsrIds.put(cfg.getDevID(), cfg.getMplsLsrID());
        }
        return lsrIds;
    }

    private QAsnRouteLsp getRouteLsp(Integer devID, RsvpTeLsp lsp) {
        QAsnRouteLsp asnLsp = new QAsnRouteLsp();
        asnLsp.oLspKey.neID = devID;
        asnLsp.oLspKey.iLspID = lsp.getMplsTunnelInstance();
        asnLsp.oLspKey.iSessionID = lsp.getMplsSessionID();
        asnLsp.oLspKey.poOutStrLsrID = StringUtil.globalByte((String)lsp.getMplsTunnelEgressLSRId());
        asnLsp.oLspKey.strLsrID = StringUtil.globalByte((String)lsp.getMplsTunnelIngressLSRId());
        asnLsp.iTnlLspType = 1;
        if (CollectionUtils.isEmpty((Collection)lsp.getRsvpTeLspARHops())) {
            return asnLsp;
        }
        ArrayList<QAsnRouteHop> asnHops = new ArrayList<QAsnRouteHop>();
        QAsnRouteHop asnHop = new QAsnRouteHop();
        asnHop.iLsrType = LSR_TYPE_ENUM.INGRESS;
        asnHop.strInIFIP = AsnUtil.getBytes((String)"");
        asnHop.iInLabel = -1;
        asnHop.strHopLsrID = StringUtil.globalByte((String)lsp.getMplsTunnelIngressLSRId());
        asnHops.add(asnHop);
        for (RsvpTeLspARHop hop : lsp.getRsvpTeLspARHops()) {
            QAsnRouteHop lastAsnHop = (QAsnRouteHop)asnHops.get(asnHops.size() - 1);
            int iType = (int)(hop.getMplsTunnelARHopIndex() % 3L);
            if (iType == 0) {
                lastAsnHop.strOutIFIP = AsnUtil.getBytes((String)hop.getMplsTunnelARHopIpAddr());
                continue;
            }
            if (iType == 1) {
                lastAsnHop.strNextHop = AsnUtil.getBytes((String)hop.getMplsTunnelARHopIpAddr());
                lastAsnHop.iOutLabel = AsnUtil.intValue((Long)hop.getMplsTunnelARHopLable());
                QAsnRouteHop newAsnHop = new QAsnRouteHop();
                newAsnHop.strInIFIP = AsnUtil.getBytes((String)hop.getMplsTunnelARHopIpAddr());
                newAsnHop.iInLabel = AsnUtil.intValue((Long)hop.getMplsTunnelARHopLable());
                newAsnHop.iLsrType = LSR_TYPE_ENUM.TRANSIT;
                asnHops.add(newAsnHop);
                continue;
            }
            if (iType != 2) continue;
            lastAsnHop.strHopLsrID = AsnUtil.getBytes((String)hop.getMplsTunnelARHopIpAddr());
        }
        ((QAsnRouteHop)asnHops.get((int)(asnHops.size() - 1))).iLsrType = LSR_TYPE_ENUM.EGRESS;
        ((QAsnRouteHop)asnHops.get((int)(asnHops.size() - 1))).strNextHop = AsnUtil.getBytes((String)"");
        asnLsp.lstRouteHop.addAll(asnHops);
        return null;
    }

    private QAsnRouteTunnel getRouteTunnel(Integer devID, RsvpTeLsp lsp) {
        QAsnRouteTunnel tunnel = new QAsnRouteTunnel();
        RsvpTeTunnel mo = new RsvpTeTunnel();
        mo.setDevID(devID);
        mo.setTunnelName(lsp.getTunnelName());
        tunnel.oTunnelKey = new RsvpTeTunnelFdnParser().getUniResID((VmfMO)mo);
        tunnel.iTransportType = 1;
        tunnel.iSignalType = 4;
        tunnel.strIngressLsrID = StringUtil.globalByte((String)lsp.getMplsTunnelIngressLSRId());
        tunnel.strEgressLsrID = StringUtil.globalByte((String)lsp.getMplsTunnelEgressLSRId());
        tunnel.iTunnelID = lsp.getMplsSessionID();
        tunnel.strTunnelName = StringUtil.globalByte((String)lsp.getTunnelName());
        tunnel.iBindingTnlIf = 1;
        tunnel.strDestinationIP = StringUtil.globalByte((String)lsp.getMplsTunnelEgressLSRId());
        QAsnRouteLsp asnLsp = this.getRouteLsp(devID, lsp);
        if (!CollectionUtils.isEmpty((Collection)asnLsp.lstRouteHop)) {
            QAsnRouteHop asnHop = (QAsnRouteHop)asnLsp.lstRouteHop.iterator().next();
            tunnel.iPosition = asnHop.iLsrType;
            tunnel.iNextHop = asnHop.strNextHop;
        }
        return tunnel;
    }

    private void queryBypassRoutes(List<RsvpTeLsp> bypassTunnelNames, QAsnGetBypassTunnelReq req, QAsnGetBypassTunnelRsp rsp) {
        Map<Integer, String> lsrIds;
        if (CollectionUtils.isEmpty(bypassTunnelNames)) {
            return;
        }
        Map<Integer, Collection<RsvpTeLsp>> byPassLspResults = null;
        try {
            byPassLspResults = this.queryRsvpTeLspFromDev(bypassTunnelNames, rsp.oResult, null);
            lsrIds = this.getLsrIdByDevids(byPassLspResults.keySet());
        }
        catch (VMFException e) {
            this.getLogger().error("Get data failed!" + (Object)((Object)e));
            rsp.oResult.result = e.getErrorCode();
            return;
        }
        if (rsp.oResult.errList.size() == req.lstNeID.size()) {
            rsp.oResult.result = 1107329319;
            return;
        }
        if (null != byPassLspResults) {
            for (Map.Entry<Integer, Collection<RsvpTeLsp>> result : byPassLspResults.entrySet()) {
                String lsrId = lsrIds.get(result.getKey());
                if (StringUtil.isEmpty((String)lsrId)) {
                    this.addErrInfo(rsp.oResult, 1107329319, result.getKey(), "", 0x22000022, "");
                    continue;
                }
                for (RsvpTeLsp lsp : result.getValue()) {
                    if (!lsrId.equals(lsp.getMplsTunnelIngressLSRId())) continue;
                    rsp.lstBypassTunnel.add((Object)this.getRouteTunnel(lsp.getDevID(), lsp));
                }
            }
        }
    }

    private Map<Integer, Collection<RsvpTeLsp>> queryRsvpTeLspFromDev(List<RsvpTeLsp> filterMOs, QAsnErrInfoReturn result, List<String> queryFieldNames) throws VMFException {
        DefaultMOService pollService = new DefaultMOService();
        for (RsvpTeLsp mo : filterMOs) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(mo.getDevID().intValue());
            queryContext.addQueryAttributes(mo.getFeatureName(), (VmfMO)mo, queryFieldNames);
            pollService.addQueryJob(queryContext);
        }
        pollService.poll();
        HashMap<Integer, Collection<RsvpTeLsp>> queryResults = new HashMap<Integer, Collection<RsvpTeLsp>>();
        for (RsvpTeLsp mo : filterMOs) {
            ErrorInfo error = pollService.getErrorInfo((VmfMO)mo);
            if (!AsnTranslatorUtil.isSuccess((ErrorInfo)error)) {
                this.addErrInfo(result, 1107329319, mo.getDevID(), "", error.getErrorCode(), error.getErrorMessage());
                continue;
            }
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(mo.getDevID().intValue());
            Collection queryResult = queryContext.getQueryResult(RsvpTeLsp.class);
            if (CollectionUtils.isEmpty((Collection)queryResult)) continue;
            queryResults.put(mo.getDevID(), queryResult);
        }
        return queryResults;
    }

    private static final class LSR_TYPE_ENUM {
        public static final Integer EGRESS = 3;
        public static final Integer INGRESS = 1;
        public static final Integer TRANSIT = 2;

        private LSR_TYPE_ENUM() {
        }
    }
}

