/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyResult;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnEnableTunnelReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnEnableTunnelRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.mpls.common.MplsAsnUtil;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.service.StaticTunnelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class EnableTunnelTask
extends AbstractConfigQTask<QAsnEnableTunnelReq, QAsnEnableTunnelRsp> {
    private IFdnParser<StaticTunnel> staticTunnelFdnParser = MplsUtil.getStaticTunnelFdnParser();
    private IFdnParser<RsvpTeTunnel> rsvpTeTunnelFdnParser = new RsvpTeTunnelFdnParser();
    private StaticTunnelService service = new StaticTunnelService();

    public EnableTunnelTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(RsvpTeTunnel.class, (ICompositeService)new DefaultCompositeService(RsvpTeTunnel.class));
        this.addMoCompositeService(StaticTunnel.class, (ICompositeService)this.service);
    }

    protected void decode(QAsnEnableTunnelReq req, Task task, IAsnTranslationContext context) {
        if (CollectionUtils.isEmpty((Collection)req.lstTunnelKey)) {
            return;
        }
        ArrayList<RsvpTeTunnel> rsvpTeFdnTunnels = new ArrayList<RsvpTeTunnel>();
        ArrayList<StaticTunnel> staticFdnTunnels = new ArrayList<StaticTunnel>();
        ArrayList<StaticTunnel> dbStaticFdnTunnels = new ArrayList();
        MplsAsnUtil.parseTunnelKeys(req.lstTunnelKey, rsvpTeFdnTunnels, staticFdnTunnels);
        try {
            MplsDao dao = MplsDao.newInstance();
            if (!CollectionUtils.isEmpty(rsvpTeFdnTunnels)) {
                dao.loadRsvpTeTunnelInterface(rsvpTeFdnTunnels, false);
            }
            if (!CollectionUtils.isEmpty(staticFdnTunnels)) {
                dbStaticFdnTunnels = dao.loadStaticTunnelInterfaceByFdn(staticFdnTunnels, false);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("EnableTunnel load Interface failed!", (Throwable)e);
        }
        int tnlEnable = req.iTnlEnable;
        Context ctx = context.getTransactionContext();
        if (!CollectionUtils.isEmpty(rsvpTeFdnTunnels)) {
            this.setRsvpTeTunnelChanges(rsvpTeFdnTunnels, tnlEnable, ctx);
        }
        if (!CollectionUtils.isEmpty(dbStaticFdnTunnels)) {
            this.setStaticCRTunnelChanges(dbStaticFdnTunnels, tnlEnable, ctx);
        }
    }

    private void setStaticCRTunnelChanges(Collection<StaticTunnel> staticFdnTunnels, int tnlEnable, Context ctx) {
        IMOChangeRecord tunnelRecorder = ctx.addChangeRecord(StaticTunnel.class);
        PropertyChangeItem tunnelStatusItem = new PropertyChangeItem("trafficEnable");
        for (StaticTunnel tunnel : staticFdnTunnels) {
            tunnel.setTrafficEnable(AsnUtil.parseBoolean((Integer)tnlEnable));
            tunnelRecorder.addModify((Object)tunnel, tunnelStatusItem);
        }
    }

    private void setRsvpTeTunnelChanges(List<RsvpTeTunnel> rsvpTeFdnTunnels, int tnlEnable, Context ctx) {
        IMOChangeRecord ifmRecorder = ctx.addChangeRecord(Interface.class);
        IMOChangeRecord tunnelRecorder = ctx.addChangeRecord(RsvpTeTunnel.class);
        OperResult operResult = ctx.getOperResult();
        PropertyChangeItem ifmStatusItem = new PropertyChangeItem("ifAdminStatus");
        PropertyChangeItem tunnelStatusItem = new PropertyChangeItem("adminStatus");
        for (RsvpTeTunnel tunnel : rsvpTeFdnTunnels) {
            List ifms = tunnel.getKeyRefMos(Interface.class);
            if (CollectionUtils.isEmpty((Collection)ifms)) {
                operResult.addMoOperResult((VmfMO)MplsUtil.translate2Interface(tunnel), 1107498867);
                continue;
            }
            Interface ifm = (Interface)ifms.iterator().next();
            ifm.setIfAdminStatus(Integer.valueOf(tnlEnable));
            ifmRecorder.addModify((Object)ifm, ifmStatusItem);
            tunnel.setAdminStatus(Integer.valueOf(tnlEnable));
            tunnelRecorder.addModify((Object)tunnel, tunnelStatusItem);
        }
    }

    protected void encode(QAsnEnableTunnelRsp rsp, IAsnTranslationContext context) {
        QAsnTunnelKeyResult asn;
        Context ctx = context.getTransactionContext();
        OperResult operResult = ctx.getOperResult();
        ArrayList mos = new ArrayList();
        IMOChangeRecord rsvpTeRecord = ctx.addChangeRecord(RsvpTeTunnel.class);
        mos.addAll(rsvpTeRecord.getModifies());
        IMOChangeRecord staticCRRecord = ctx.addChangeRecord(StaticTunnel.class);
        mos.addAll(staticCRRecord.getModifies());
        rsp.oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn(mos, (OperResult)operResult);
        for (RsvpTeTunnel mo : rsvpTeRecord.getModifies()) {
            asn = new QAsnTunnelKeyResult();
            if (mo instanceof RsvpTeTunnel) {
                asn.oTunnelKey = this.rsvpTeTunnelFdnParser.getUniResID((VmfMO)mo);
            } else if (mo instanceof StaticTunnel) {
                asn.oTunnelKey = this.staticTunnelFdnParser.getUniResID((VmfMO)((StaticTunnel)mo));
            } else {
                this.getLogger().info("no control");
            }
            asn.result = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)mo, (OperResult)operResult);
            rsp.lstFail.add((Object)asn);
        }
        for (RsvpTeTunnel mo : staticCRRecord.getModifies()) {
            asn = new QAsnTunnelKeyResult();
            if (mo instanceof RsvpTeTunnel) {
                asn.oTunnelKey = this.rsvpTeTunnelFdnParser.getUniResID((VmfMO)mo);
            } else if (mo instanceof StaticTunnel) {
                asn.oTunnelKey = this.staticTunnelFdnParser.getUniResID((VmfMO)((StaticTunnel)mo));
            } else {
                this.getLogger().info("no control");
            }
            asn.result = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)mo, (OperResult)operResult);
            rsp.lstFail.add((Object)asn);
        }
    }

    protected Integer getAsnBestEffort(QAsnEnableTunnelReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnEnableTunnelReq req) {
        return req.strTaskFlag;
    }
}

