/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_interface_model.QAsnPortResult;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnInterfaceMplsInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnEnableInterfaceMplsReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnEnableInterfaceMplsRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractSingleMoConfigQTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsInterface;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.service.MplsInterfaceService;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnInterfaceMplsInfoTranslator;
import com.huawei.vmf.adapter.mpls.translation.asn.spec.QAsnPortResult2MplsInterfaceTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class EnableInterfaceMplsTask
extends AbstractSingleMoConfigQTask<QAsnEnableInterfaceMplsReq, QAsnEnableInterfaceMplsRsp, QAsnInterfaceMplsInfo, QAsnPortResult, MplsInterface> {
    protected EnableInterfaceMplsTask() {
        super(MplsInterface.class, EOperationType.MODIFY, (IAsnTranslator)new QAsnInterfaceMplsInfoTranslator(), null);
        this.addMoCompositeService(MplsInterface.class, (ICompositeService)new MplsInterfaceService());
    }

    protected void decode(QAsnEnableInterfaceMplsReq req, Task task, IAsnTranslationContext context) {
        MplsDao dao = MplsDao.newInstance();
        try {
            Collection mifms = this.getDecodeTranslator().decode((Collection)req.lstInterfaceMplsInfo, context);
            Collection dbMifms = dao.queryByKey(MplsInterface.class, mifms, false);
            IMOChangeRecord record = context.getTransactionContext().addChangeRecord(MplsInterface.class);
            for (MplsInterface mifm : mifms) {
                boolean exsist = dbMifms.contains(mifm);
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{mifm.getDevID(), mifm.getVrID(), mifm.getInterfaceName()});
                Integer mask = (Integer)context.getProperty(key);
                if (mask.equals(1)) {
                    if (exsist) {
                        record.addModify((Object)mifm, new PropertyChangeItem(MplsInterface.class.getName()));
                        continue;
                    }
                    record.cancelModify((Object)mifm);
                    record.addCreate((Object)mifm);
                    continue;
                }
                if (mask.equals(0)) {
                    if (!exsist) continue;
                    record.cancelModify((Object)mifm);
                    record.addDelete((Object)mifm);
                    continue;
                }
                this.getLogger().debug("defense coding, do nothing.");
            }
        }
        catch (VMFException e) {
            this.getLogger().error("EnableInterfaceMplsTask decode failed!", (Throwable)e);
        }
    }

    protected void encode(QAsnEnableInterfaceMplsRsp rsp, IAsnTranslationContext context) {
        Set mos = context.getTransactionContext().getChangeRecord(this.getMoClazz()).getAllChanges();
        OperResult operResult = context.getTransactionContext().getOperResult();
        rsp.oResult.result = AsnTranslatorUtil.getMosResultCode((Collection)mos, (OperResult)operResult);
        if (CollectionUtils.isEmpty((Collection)mos)) {
            return;
        }
        QAsnPortResult2MplsInterfaceTranslator translator = new QAsnPortResult2MplsInterfaceTranslator();
        try {
            ArrayList<QAsnPortResult> encodeAsns = new ArrayList<QAsnPortResult>();
            for (MplsInterface mo : mos) {
                QAsnPortResult asn = (QAsnPortResult)translator.encode(mo, context);
                asn.result = AsnTranslatorUtil.getMoQAsnSingleReturn((VmfMO)mo, (OperResult)operResult);
                encodeAsns.add(asn);
            }
            this.setEncodeAsns(encodeAsns, rsp, context);
        }
        catch (VMFException e) {
            this.getLogger().error("MplsInterface translate to QAsnPortResult failed!", (Throwable)e);
        }
    }

    protected Integer getAsnBestEffort(QAsnEnableInterfaceMplsReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnEnableInterfaceMplsReq req) {
        return req.strTaskFlag;
    }

    protected Collection<QAsnInterfaceMplsInfo> getDecodeAsns(QAsnEnableInterfaceMplsReq req) {
        return req.lstInterfaceMplsInfo;
    }

    protected void setEncodeAsns(Collection<QAsnPortResult> encodeAsns, QAsnEnableInterfaceMplsRsp rsp, IAsnTranslationContext context) {
        rsp.lstInterfaceKey.addAll(encodeAsns);
    }
}

