/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_ip_tpoam_model.QAsnTPOamResKey;
import com.huawei.network.qasn.m_q_ip_tpoam_model.QAsnTPOamResKeyList;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelStatusInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnDeployTunnelReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnDeployTunnelRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.fdn.StaticTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.fservice.tpoam.service.ITpoamService;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.common.MplsAsnUtil;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDevDao;
import com.huawei.vmf.adapter.mpls.service.RsvpTETunnelService;
import com.huawei.vmf.adapter.mpls.service.StaticTunnelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class DeployTunnelTask
extends AbstractConfigQTask<QAsnDeployTunnelReq, QAsnDeployTunnelRsp> {
    public static final int TP_OAM_TYPE_Y1731 = 2;
    public static final int TP_OAM_TYPE_Y1711 = 1;
    public static final int CONFIGOAM_ERROR = 1107427139;

    public DeployTunnelTask() {
        super(EOperationType.DEPLOY);
        this.addMoCompositeService(RsvpTeTunnel.class, (ICompositeService)new RsvpTETunnelService());
        this.addMoCompositeService(StaticTunnel.class, (ICompositeService)new StaticTunnelService());
    }

    protected void decode(QAsnDeployTunnelReq req, Task task, IAsnTranslationContext context) {
        if (CollectionUtils.isEmpty((Collection)req.lstTunnelKey)) {
            return;
        }
        ArrayList<RsvpTeTunnel> rsvpTeFdnTunnels = new ArrayList<RsvpTeTunnel>();
        ArrayList<StaticTunnel> staticFdnTunnels = new ArrayList<StaticTunnel>();
        MplsAsnUtil.parseTunnelKeys(req.lstTunnelKey, rsvpTeFdnTunnels, staticFdnTunnels);
        Context ctx = context.getTransactionContext();
        if (!CollectionUtils.isEmpty(rsvpTeFdnTunnels)) {
            try {
                MplsUtil.setDeployTunnelCotext(rsvpTeFdnTunnels, context);
            }
            catch (VMFException e) {
                for (RsvpTeTunnel mo : rsvpTeFdnTunnels) {
                    AsnTranslatorUtil.addMoOperResult((VmfMO)mo, (Context)context.getTransactionContext(), (int)e.getErrorCode());
                }
                this.getLogger().error("setDeployTunnelCotext failed!", (Throwable)e);
            }
        }
        if (!CollectionUtils.isEmpty(staticFdnTunnels)) {
            MplsUtil.setDeployStaticTunnelChanges(staticFdnTunnels, ctx);
        }
    }

    protected void encode(QAsnDeployTunnelRsp rsp, IAsnTranslationContext context) {
        Context ctx = context.getTransactionContext();
        OperResult operResult = ctx.getOperResult();
        ArrayList mos = new ArrayList();
        IMOChangeRecord rsvpTeRecord = ctx.addChangeRecord(RsvpTeTunnel.class);
        mos.addAll(rsvpTeRecord.getAllChanges());
        IMOChangeRecord staticCRRecord = ctx.addChangeRecord(StaticTunnel.class);
        mos.addAll(staticCRRecord.getAllChanges());
        RsvpTeTunnelFdnParser rsvpTeTunnelFdnParser = new RsvpTeTunnelFdnParser();
        IFdnParser<StaticTunnel> staticTunnelFdnParser = MplsUtil.getStaticTunnelFdnParser();
        rsp.oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn(mos, (OperResult)operResult);
        for (VmfMO mo : mos) {
            QAsnTunnelStatusInfo asn = new QAsnTunnelStatusInfo();
            if (mo instanceof RsvpTeTunnel) {
                RsvpTeTunnel rsvpTeTunnel = (RsvpTeTunnel)mo;
                asn.result = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)rsvpTeTunnel, (OperResult)operResult);
                asn.oTunnelKey = rsvpTeTunnelFdnParser.getUniResID((VmfMO)rsvpTeTunnel);
                if (asn.result.errCode == 0) {
                    asn.iEnableStatus = AsnUtil.intValue((Integer)rsvpTeTunnel.getAdminStatus());
                    asn.iRunningStatus = AsnUtil.intValue((Integer)rsvpTeTunnel.getOperStatus());
                    asn.iDeployStatus = 1;
                    asn.result.errCode = 0;
                } else {
                    asn.iEnableStatus = AsnUtil.intValue((Integer)rsvpTeTunnel.getAdminStatus());
                    asn.iRunningStatus = RsvpTeTunnel.OPER_STATUS_ENUM.DOWN;
                    asn.iDeployStatus = 0;
                }
            } else if (mo instanceof StaticTunnel) {
                StaticTunnel staticTunnel = (StaticTunnel)mo;
                asn.result = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)staticTunnel, (OperResult)operResult);
                asn.oTunnelKey = staticTunnelFdnParser.getUniResID((VmfMO)staticTunnel);
                if (asn.result.errCode == 0) {
                    asn.iEnableStatus = RsvpTeTunnel.ADMIN_STATUS_ENUM.UP;
                    asn.iRunningStatus = -1;
                    asn.iDeployStatus = 1;
                } else {
                    asn.iEnableStatus = -1;
                    asn.iRunningStatus = -1;
                    asn.iDeployStatus = 0;
                }
            } else {
                this.getLogger().info("no control");
            }
            rsp.lstTunnelFail.add((Object)asn);
        }
    }

    protected Integer getAsnBestEffort(QAsnDeployTunnelReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnDeployTunnelReq req) {
        return req.strTaskFlag;
    }

    protected void executeTask(QAsnDeployTunnelReq req, QAsnDeployTunnelRsp rsp, Task task) {
        super.executeTask((FStruct)req, (FStruct)rsp, task);
        if (rsp.oResult.result == 0 && MplsUtil.isPtn()) {
            Map<String, ErrorInfo> switchError;
            ITpoamService tpOamService = Activator.getService(ITpoamService.class);
            if (null == tpOamService) {
                this.getLogger().error("DeployTunnelTask getTPOamService is null!");
                return;
            }
            QAsnUniResIDList tpOamResLst = new QAsnUniResIDList();
            QAsnUniResIDList oamResLst = new QAsnUniResIDList();
            int len = req.lstTunnelKey.size();
            for (int i = 0; i < len; ++i) {
                QAsnUniResID resID = (QAsnUniResID)req.lstTunnelKey.get(i);
                try {
                    boolean isConfigTpoam;
                    boolean bl = isConfigTpoam = tpOamService.queryPOAM(resID) != null;
                    if (isConfigTpoam) {
                        tpOamResLst.add((Object)resID);
                        continue;
                    }
                    oamResLst.add((Object)resID);
                    continue;
                }
                catch (VMFException e1) {
                    this.getLogger().error("DeployTunnelTask tpOamService.queryPOAM failed!");
                }
            }
            QAsnTPOamResKeyList tpOamResKeyList = this.getNeedSwitch1731Oam(req.lstTunnelKey, tpOamService);
            if (!CollectionUtils.isEmpty((Collection)tpOamResKeyList) && !(switchError = MplsUtil.switchLSP(tpOamResKeyList)).isEmpty()) {
                for (int i = 0; i < rsp.lstTunnelFail.size(); ++i) {
                    QAsnTunnelStatusInfo tunnelStatusAsn = (QAsnTunnelStatusInfo)rsp.lstTunnelFail.get(i);
                    String fdn = new String(tunnelStatusAsn.oTunnelKey.strFDN);
                    if (!switchError.containsKey(fdn)) continue;
                    ErrorInfo errInfo = switchError.get(fdn);
                    rsp.oResult.result = errInfo.getErrorCode();
                    if (0 != errInfo.getErrorCode()) {
                        tunnelStatusAsn.result.errCode = 1107427139;
                    }
                    tunnelStatusAsn.result.strOperDesc = null != errInfo.getErrorMessage() ? errInfo.getErrorMessage().getBytes() : "".getBytes();
                }
            }
            if (!CollectionUtils.isEmpty((Collection)tpOamResLst)) {
                try {
                    int deployTpOamError = tpOamService.deployTPOAM(2, tpOamResLst);
                    if (0 != deployTpOamError) {
                        rsp.oResult.result = deployTpOamError;
                        return;
                    }
                }
                catch (VMFException e) {
                    this.getLogger().error("DeployTunnelTask tpOamService.deployTPOAM failed!");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)oamResLst)) {
                try {
                    this.syncTunnelOam(oamResLst);
                }
                catch (VMFException e) {
                    this.getLogger().error("sync Tunnel Oam failed!");
                }
            }
        }
    }

    private void syncTunnelOam(QAsnUniResIDList lstResID) throws VMFException {
        ArrayList<MplsOamTunnel> mplsOamLst = new ArrayList<MplsOamTunnel>();
        ArrayList<StaticTunnel> sucStaticTunnel = new ArrayList<StaticTunnel>();
        HashMap<String, StaticTunnel> staticTunelMap = new HashMap<String, StaticTunnel>();
        StaticTunnelFdnParser fdnParser = new StaticTunnelFdnParser();
        int len = lstResID.size();
        for (int i = 0; i < len; ++i) {
            QAsnUniResID resID = (QAsnUniResID)lstResID.get(i);
            StaticTunnel staticTunnel = (StaticTunnel)fdnParser.getIndexMo(resID);
            if (StaticTunnel.LSR_ROLE_ENUM.TRANSIT == staticTunnel.getLsrRole()) continue;
            sucStaticTunnel.add(staticTunnel);
            MplsOamTunnel mplsOam = new MplsOamTunnel();
            mplsOam.setDevID(staticTunnel.getDevID());
            mplsOam.setVrID(staticTunnel.getVrID());
            mplsOam.setTunnelName(staticTunnel.getTunnelName());
            mplsOamLst.add(mplsOam);
            staticTunelMap.put(new String(resID.strFDN), staticTunnel);
        }
        if (CollectionUtils.isEmpty(sucStaticTunnel)) {
            return;
        }
        if (!CollectionUtils.isEmpty(mplsOamLst)) {
            Collection oamTunnelFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamTunnel.class, mplsOamLst, true);
            for (MplsOamTunnel oamTunnel : mplsOamLst) {
                if (oamTunnelFromDB.contains(oamTunnel)) continue;
                MplsDevDao.newInstance().syncTunnelOam(mplsOamLst);
            }
        }
    }

    private QAsnTPOamResKeyList getNeedSwitch1731Oam(QAsnUniResIDList tunnelResKeyList, ITpoamService tpOamService) {
        QAsnTPOamResKeyList needSwitch1731Lst = new QAsnTPOamResKeyList();
        for (int i = 0; i < tunnelResKeyList.size(); ++i) {
            QAsnUniResID tunnelResKey = (QAsnUniResID)tunnelResKeyList.get(i);
            this.getLogger().debug("get Need Switch TpOam the resID = " + new String(tunnelResKey.strFDN));
            int neOam = MplsUtil.getOamType(tunnelResKey);
            this.getLogger().debug("get Need Switch TpOam get ne default oam = " + neOam + " and devID = " + tunnelResKey.neID);
            boolean isConfigTpoam = false;
            try {
                isConfigTpoam = tpOamService.queryPOAM(tunnelResKey) != null;
                this.getLogger().debug("get Need Switch TpOam get tp oam  isConfigTpoam = " + isConfigTpoam + " and resID = " + new String(tunnelResKey.strFDN));
            }
            catch (VMFException e) {
                this.getLogger().error("getNeedSwitch1731Oam tpOamService.queryPOAM failed!");
            }
            if (1 != neOam || !isConfigTpoam) continue;
            QAsnTPOamResKey key = new QAsnTPOamResKey();
            key.oResKey = tunnelResKey;
            this.getLogger().debug("1711 Need Switch TpOam the resID = " + new String(tunnelResKey.strFDN));
            needSwitch1731Lst.add((Object)key);
        }
        return needSwitch1731Lst;
    }
}

