/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingKeyResult;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnDeleteVirtrualNodeReq;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnDeleteVirtrualNodeRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RingMapVirtualNodeFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.RingMapVirtualNode;
import com.huawei.vmf.adapter.fservice.mpls.model.RingSinkNode;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class DeleteVirtrualNodeTask
extends AbstractConfigQTask<QAsnDeleteVirtrualNodeReq, QAsnDeleteVirtrualNodeRsp> {
    protected DeleteVirtrualNodeTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(MplsRing.class, (ICompositeService)new DefaultCompositeService(MplsRing.class));
    }

    protected void decode(QAsnDeleteVirtrualNodeReq req, Task task, IAsnTranslationContext context) {
        ArrayList<VmfMO> virtualNodes = new ArrayList<VmfMO>();
        RingMapVirtualNodeFdnParser fdnParser = new RingMapVirtualNodeFdnParser();
        for (Object nodeKey : req.virtrualNodeList) {
            virtualNodes.add(fdnParser.getIndexMo((QAsnUniResID)nodeKey));
        }
        Context ctx = context.getTransactionContext();
        IMOChangeRecord ringRecord = ctx.addChangeRecord(MplsRing.class);
        IMOChangeRecord virtualNodeRecord = ctx.addChangeRecord(RingMapVirtualNode.class);
        HashMap<String, MplsRing> ringMap = new HashMap<String, MplsRing>();
        PropertyChangeItem ringModifyItem = new PropertyChangeItem("ringMapVirtualNodes");
        ArrayList<RingSinkNode> sinkNodes = new ArrayList<RingSinkNode>();
        for (RingMapVirtualNode ringMapVirtualNode : virtualNodes) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{ringMapVirtualNode.getDevID(), ringMapVirtualNode.getVrID(), ringMapVirtualNode.getRingId()});
            MplsRing ring = (MplsRing)ringMap.get(key);
            if (ring == null) {
                ring = MplsUtil.translate2Ring(ringMapVirtualNode);
                ringMap.put(key, ring);
                ringRecord.addModify((Object)ring, ringModifyItem);
            }
            List<RingMapVirtualNode> deleteNodes = Arrays.asList(ringMapVirtualNode);
            ring.addRingMapVirtualNodes(deleteNodes);
            virtualNodeRecord.cancelModify((Object)ringMapVirtualNode);
            virtualNodeRecord.addDelete(deleteNodes);
            RingSinkNode sinkNode = new RingSinkNode();
            sinkNode.setDevID(ringMapVirtualNode.getDevID());
            sinkNode.setVrID(ringMapVirtualNode.getVrID());
            sinkNode.setRingId(ringMapVirtualNode.getRingId());
            sinkNode.setSinkNodeId(ringMapVirtualNode.getVirtualNodeId());
            sinkNodes.add(sinkNode);
        }
        try {
            Collection dbSinkNodes = MplsDao.newInstance().queryByKey(RingSinkNode.class, sinkNodes, false);
            if (CollectionUtils.isEmpty((Collection)dbSinkNodes)) {
                return;
            }
            IMOChangeRecord iMOChangeRecord = ctx.addDBChangeRecord(RingSinkNode.class);
            for (RingSinkNode sinkeNode : dbSinkNodes) {
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{sinkeNode.getDevID(), sinkeNode.getVrID(), sinkeNode.getRingId()});
                MplsRing ring = (MplsRing)ringMap.get(key);
                if (ring == null) continue;
                ring.addRingSinkNodes(Arrays.asList(sinkeNode));
                ringRecord.addModify((Object)ring, new PropertyChangeItem("ringSinkNodes"));
                iMOChangeRecord.addDelete((Object)sinkeNode);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("DeleteRingNodeTask query db RingSinkNode failed!", (Throwable)e);
        }
    }

    protected void encode(QAsnDeleteVirtrualNodeRsp rsp, IAsnTranslationContext context) {
        Context ctx = context.getTransactionContext();
        OperResult operResult = ctx.getOperResult();
        IMOChangeRecord ringRecord = ctx.addChangeRecord(MplsRing.class);
        Set mos = ctx.getChangeRecord(RingMapVirtualNode.class).getDeletes();
        rsp.result = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)ringRecord.getModifies(), (OperResult)operResult);
        RingMapVirtualNodeFdnParser fdnParser = new RingMapVirtualNodeFdnParser();
        for (RingMapVirtualNode mo : mos) {
            QAsnSPRingKeyResult asn = new QAsnSPRingKeyResult();
            asn.oFdn = fdnParser.getUniResID((VmfMO)mo);
            asn.result = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)MplsUtil.translate2Ring(mo), (OperResult)operResult);
            rsp.ringKeyResultList.add((Object)asn);
        }
    }

    protected Integer getAsnBestEffort(QAsnDeleteVirtrualNodeReq req) {
        return null;
    }

    protected byte[] getAsnTaskFlag(QAsnDeleteVirtrualNodeReq req) {
        return req.strTaskFlag;
    }
}

