/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyResult;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnDeleteTunnleReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnDeleteTunnleRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.RsvpTeTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.ExplicitPath;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnelPathConstraint;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.fservice.tpoam.service.ITpoamService;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.common.MplsAsnUtil;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.service.StaticTunnelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DeleteTunnleTask
extends AbstractConfigQTask<QAsnDeleteTunnleReq, QAsnDeleteTunnleRsp> {
    private static final Integer NEED_DEL_EX_PATH = 1;

    public DeleteTunnleTask() {
        super(EOperationType.DELETE);
        this.addMoCompositeService(RsvpTeTunnel.class, (ICompositeService)new DefaultCompositeService(RsvpTeTunnel.class));
        this.addMoCompositeService(StaticTunnel.class, (ICompositeService)new StaticTunnelService());
    }

    protected void decode(QAsnDeleteTunnleReq req, Task task, IAsnTranslationContext context) {
        if (CollectionUtils.isEmpty((Collection)req.lstTunnelKey)) {
            return;
        }
        ArrayList<RsvpTeTunnel> rsvpTeFdnTunnels = new ArrayList<RsvpTeTunnel>();
        ArrayList<StaticTunnel> staticFdnTunnels = new ArrayList<StaticTunnel>();
        MplsAsnUtil.parseTunnelKeys(req.lstTunnelKey, rsvpTeFdnTunnels, staticFdnTunnels);
        Context ctx = context.getTransactionContext();
        Integer needDelExPath = req.needDelExPath;
        if (!CollectionUtils.isEmpty(staticFdnTunnels)) {
            try {
                this.setStaticCRTunnelChanges(staticFdnTunnels, ctx, needDelExPath);
                this.setOamTunnelChanges(staticFdnTunnels, ctx);
            }
            catch (VMFException e) {
                this.getLogger().error("DeleteTunnleTask setStaticCRTunnelChanges failed!");
            }
        }
        if (!CollectionUtils.isEmpty(rsvpTeFdnTunnels)) {
            try {
                this.setRsvpTeTunnelChanges(rsvpTeFdnTunnels, ctx, needDelExPath, context);
            }
            catch (VMFException e) {
                this.getLogger().error("DeleteTunnleTask setRsvpTeTunnelChanges failed!");
            }
        }
    }

    private void setOamTunnelChanges(List<StaticTunnel> staticFdnTunnels, Context ctx) {
        for (StaticTunnel staticTunnel : staticFdnTunnels) {
            ArrayList<MplsOamTunnel> tunnelOamList = new ArrayList<MplsOamTunnel>();
            MplsOamTunnel tunnelOam = new MplsOamTunnel();
            tunnelOam.setDevID(staticTunnel.getDevID());
            tunnelOam.setVrID(staticTunnel.getVrID());
            tunnelOam.setTunnelName(staticTunnel.getTunnelName());
            tunnelOamList.add(tunnelOam);
            try {
                Collection oamTunnelFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByKey(MplsOamTunnel.class, tunnelOamList, true);
                if (CollectionUtils.isEmpty((Collection)oamTunnelFromDB)) continue;
                staticTunnel.addKeyRefMos(oamTunnelFromDB);
                this.addTunnelOamDeployRecord(ctx, staticTunnel.getKeyRefMos(MplsOamTunnel.class));
            }
            catch (VMFException e) {
                this.getLogger().error("DeleteTunnleTask setOamTunnelChanges operation error.");
            }
        }
    }

    protected void addTunnelOamDeployRecord(Context context, List<MplsOamTunnel> tpKeyRefMos) throws VMFException {
        if (CollectionUtils.isEmpty(tpKeyRefMos)) {
            return;
        }
        IMOChangeRecord tpMoChangeRecord = context.addDBChangeRecord(MplsOamTunnel.class);
        for (MplsOamTunnel oamTunnel : tpKeyRefMos) {
            tpMoChangeRecord.addDelete((Object)oamTunnel);
        }
    }

    private void setStaticCRTunnelChanges(List<StaticTunnel> staticFdnTunnels, Context ctx, Integer needDelExPath) throws VMFException {
        MplsDao.newInstance().loadStaticTunnelInterfaceByFdn(staticFdnTunnels, false);
        IMOChangeRecord moChangeRecord = ctx.addChangeRecord(StaticTunnel.class);
        moChangeRecord.addDelete(staticFdnTunnels);
        this.deleteInterface(staticFdnTunnels, ctx);
    }

    private void setRsvpTeTunnelChanges(List<RsvpTeTunnel> rsvpTeFdnTunnels, Context ctx, Integer needDelExPath, IAsnTranslationContext context) throws VMFException {
        MplsDao.newInstance().loadRsvpTeTunnelInterface(rsvpTeFdnTunnels, true);
        IMOChangeRecord moChangeRecord = ctx.addChangeRecord(RsvpTeTunnel.class);
        moChangeRecord.addDelete(rsvpTeFdnTunnels);
        this.deleteOam(rsvpTeFdnTunnels);
        this.deleteInterface(rsvpTeFdnTunnels, ctx);
        try {
            MplsUtil.setKeyRefToContext(rsvpTeFdnTunnels, context);
        }
        catch (VMFException e) {
            this.getLogger().error("MplsUtil.setKeyRefToContext failed", (Throwable)e);
            context.getTransactionContext().addMoOperResults(rsvpTeFdnTunnels, e.getErrorCode());
        }
        if (NEED_DEL_EX_PATH.equals(needDelExPath)) {
            this.deleteExpath(rsvpTeFdnTunnels, ctx);
        }
    }

    protected void deleteExpath(Collection<RsvpTeTunnel> tunnels, Context context) {
        MplsDao dao = MplsDao.newInstance();
        try {
            dao.queryByParentKey(RsvpTeTunnelPathConstraint.class, RsvpTeTunnel.class, tunnels);
        }
        catch (VMFException e) {
            this.getLogger().error("RsvpTeTunnelPathConstraint query exception. tunnels=" + tunnels, (Throwable)e);
            return;
        }
        IMOChangeRecord explicitPathChangeRecord = context.addChangeRecord(ExplicitPath.class);
        for (RsvpTeTunnel mo : tunnels) {
            for (String pathName : MplsUtil.getTunnelExpathNames(mo)) {
                this.dealExplictPath(pathName, (IMOChangeRecord<ExplicitPath>)explicitPathChangeRecord, mo);
            }
        }
    }

    protected void deleteInterface(Collection<? extends VmfMO> tunnels, Context context) {
        IMOChangeRecord ifmChangeRecord = context.addDBChangeRecord(Interface.class);
        for (VmfMO vmfMO : tunnels) {
            List ifms = vmfMO.getKeyRefMos(Interface.class);
            if (CollectionUtils.isEmpty((Collection)ifms)) continue;
            ifmChangeRecord.addDelete((Collection)ifms);
        }
    }

    protected void deleteOam(Collection<RsvpTeTunnel> tunnels) {
    }

    protected void encode(QAsnDeleteTunnleRsp rsp, IAsnTranslationContext context) {
        Context ctx = context.getTransactionContext();
        OperResult operResult = ctx.getOperResult();
        ArrayList mos = new ArrayList();
        mos.addAll(ctx.getChangeRecord(RsvpTeTunnel.class).getAllChanges());
        mos.addAll(ctx.getChangeRecord(StaticTunnel.class).getAllChanges());
        rsp.oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn(mos, (OperResult)operResult);
        RsvpTeTunnelFdnParser rsvpTeTunnelFdnParser = new RsvpTeTunnelFdnParser();
        IFdnParser<StaticTunnel> staticTunnelFdnParser = MplsUtil.getStaticTunnelFdnParser();
        for (VmfMO mo : mos) {
            QAsnTunnelKeyResult asn = new QAsnTunnelKeyResult();
            if (mo instanceof RsvpTeTunnel) {
                asn.oTunnelKey = rsvpTeTunnelFdnParser.getUniResID((VmfMO)((RsvpTeTunnel)mo));
            } else if (mo instanceof StaticTunnel) {
                asn.oTunnelKey = staticTunnelFdnParser.getUniResID((VmfMO)((StaticTunnel)mo));
            } else {
                this.getLogger().debug("no control");
            }
            asn.result = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)mo, (OperResult)operResult);
            rsp.lstFail.add((Object)asn);
        }
    }

    protected Integer getAsnBestEffort(QAsnDeleteTunnleReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnDeleteTunnleReq req) {
        return req.strTaskFlag;
    }

    private void dealExplictPath(String pathName, IMOChangeRecord<ExplicitPath> explicitPathChangeRecord, RsvpTeTunnel tunnel) {
        if (!StringUtils.hasText((String)pathName)) {
            return;
        }
        ExplicitPath explicitPath = new ExplicitPath();
        explicitPath.setDevID(tunnel.getDevID());
        explicitPath.setVrID(tunnel.getVrID());
        explicitPath.setExplicitPathName(pathName);
        tunnel.addKeyRefMo((VmfMO)explicitPath);
        explicitPathChangeRecord.addDelete((Object)explicitPath);
    }

    protected void executeTask(QAsnDeleteTunnleReq req, QAsnDeleteTunnleRsp rsp, Task task) {
        super.executeTask((FStruct)req, (FStruct)rsp, task);
        if (MplsUtil.isPtn()) {
            ITpoamService tpOamService = Activator.getService(ITpoamService.class);
            int len = req.lstTunnelKey.size();
            for (int i = 0; i < len; ++i) {
                QAsnUniResID resID = (QAsnUniResID)req.lstTunnelKey.get(i);
                if (!MplsUtil.isConfigTpOam(resID)) continue;
                try {
                    tpOamService.deleteTPOAM(2, resID);
                    continue;
                }
                catch (VMFException e) {
                    this.getLogger().error("DeleteTunnleTask tpOamService.deleteTPOAM failed!");
                }
            }
        }
    }
}

