/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingKeyResult;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingOAMBase;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingOAMInfo;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingOAMInfoList;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnDeleteSPRingReq;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnDeleteSPRingRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.MplsRingFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.Ring;
import com.huawei.vmf.adapter.fservice.mpls.model.RingPayload;
import com.huawei.vmf.adapter.fservice.tpoam.service.ITpoamService;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class DeleteSPRingTask
extends AbstractConfigQTask<QAsnDeleteSPRingReq, QAsnDeleteSPRingRsp> {
    private static final int OAM_MODE_1731 = 2;

    protected DeleteSPRingTask() {
        super(EOperationType.DELETE);
        this.addMoCompositeService(MplsRing.class, (ICompositeService)new DefaultCompositeService(MplsRing.class));
    }

    protected void decode(QAsnDeleteSPRingReq req, Task task, IAsnTranslationContext context) {
        MplsRingFdnParser fdnParser = new MplsRingFdnParser();
        ArrayList<VmfMO> mos = new ArrayList<VmfMO>();
        for (Object asn : req.ringKeyList) {
            QAsnUniResID resId = (QAsnUniResID)asn;
            mos.add(fdnParser.getIndexMo(resId));
        }
        Context ctx = context.getTransactionContext();
        IMOChangeRecord record = ctx.addChangeRecord(MplsRing.class);
        record.addDelete(mos);
        ArrayList<RingPayload> mapNodes = new ArrayList<RingPayload>();
        for (Object asn : req.ringKeyList) {
            QAsnUniResID resId = (QAsnUniResID)asn;
            MplsRing ring = (MplsRing)fdnParser.getIndexMo(resId);
            RingPayload payLoad = new RingPayload();
            payLoad.setDevID(ring.getDevID());
            payLoad.setVrID(ring.getVrID());
            payLoad.setRingId(ring.getRingId());
            mapNodes.add(payLoad);
        }
        String[] fieldNames = new String[]{"devID", "vrID", "ringId"};
        try {
            Collection dbMapNodes = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByFields(RingPayload.class, fieldNames, mapNodes, false);
            if (!CollectionUtils.isEmpty((Collection)dbMapNodes)) {
                Context payLoadcontext = new Context();
                IMOChangeRecord payLoadRecord = payLoadcontext.addChangeRecord(RingPayload.class);
                payLoadRecord.addDelete(dbMapNodes);
                MplsDao.newInstance(payLoadcontext).merge(RingPayload.class, false);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("Delete table ringPayload failed!", (Throwable)e);
        }
    }

    protected void encode(QAsnDeleteSPRingRsp rsp, IAsnTranslationContext context) {
        Context ctx = context.getTransactionContext();
        IMOChangeRecord record = ctx.addChangeRecord(MplsRing.class);
        Set mos = record.getDeletes();
        OperResult operResult = ctx.getOperResult();
        rsp.result = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)mos, (OperResult)operResult);
        MplsRingFdnParser fdnParser = new MplsRingFdnParser();
        for (MplsRing mo : mos) {
            QAsnSPRingKeyResult asn = new QAsnSPRingKeyResult();
            asn.oFdn = fdnParser.getUniResID((VmfMO)mo);
            asn.result = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)mo, (OperResult)operResult);
            rsp.ringKeyResultList.add((Object)asn);
        }
    }

    protected Integer getAsnBestEffort(QAsnDeleteSPRingReq req) {
        return null;
    }

    protected byte[] getAsnTaskFlag(QAsnDeleteSPRingReq req) {
        return req.strTaskFlag;
    }

    public void execute(QAsnDeleteSPRingReq req, QAsnDeleteSPRingRsp rsp, Task task) {
        super.execute((FStruct)req, (FStruct)rsp, task);
        if (rsp.result.result == 0) {
            QAsnSPRingOAMInfoList oamList = new QAsnSPRingOAMInfoList();
            int len = req.ringKeyList.size();
            for (int i = 0; i < len; ++i) {
                QAsnSPRingOAMInfo eastOam = new QAsnSPRingOAMInfo();
                eastOam.sprFDN = (QAsnUniResID)req.ringKeyList.get(i);
                eastOam.direction = Ring.RING_DIRECTION_ENUM.EAST;
                eastOam.oamInfo = new QAsnSPRingOAMBase();
                eastOam.oamInfo.enable = Ring.OAM_ACTIVE_STATE_ENUM.DEACTIVE;
                eastOam.oamInfo.mode = 2;
                oamList.add((Object)eastOam);
                QAsnSPRingOAMInfo westOam = new QAsnSPRingOAMInfo();
                westOam.sprFDN = (QAsnUniResID)req.ringKeyList.get(i);
                westOam.direction = Ring.RING_DIRECTION_ENUM.WEST;
                westOam.oamInfo = new QAsnSPRingOAMBase();
                westOam.oamInfo.enable = Ring.OAM_ACTIVE_STATE_ENUM.DEACTIVE;
                westOam.oamInfo.mode = 2;
                oamList.add((Object)westOam);
            }
            ITpoamService tpoamService = Activator.getService(ITpoamService.class);
            try {
                tpoamService.modifyRingY1731(oamList);
            }
            catch (VMFException e) {
                this.getLogger().error("DeleteSPRingTask modifyTpOam failed!", (Throwable)e);
            }
        }
    }

    private void setOamTunnelChanges(List<MplsRing> ringFdn, Context ctx) {
        for (MplsRing ring : ringFdn) {
            ArrayList<Ring> ringOamList = new ArrayList<Ring>();
            Ring ringOam = new Ring();
            ringOam.setDevID(ring.getDevID());
            ringOam.setVrID(ring.getVrID());
            ringOam.setRingId(BigInteger.valueOf(ring.getRingId().intValue()));
            ringOamList.add(ringOam);
            String[] conditions = new String[]{"devID", "vrID", "ringId"};
            try {
                Collection oamRingFromDB = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, null).queryByFields(Ring.class, conditions, ringOamList, true);
                if (CollectionUtils.isEmpty((Collection)oamRingFromDB)) continue;
                ring.addKeyRefMos(oamRingFromDB);
                this.addRingOamDeployRecord(ctx, ring.getKeyRefMos(Ring.class));
            }
            catch (VMFException e) {
                this.getLogger().error("DeleteTunnleTask setOamTunnelChanges operation error.");
            }
        }
    }

    protected void addRingOamDeployRecord(Context context, List<Ring> tpKeyRefMos) throws VMFException {
        if (CollectionUtils.isEmpty(tpKeyRefMos)) {
            return;
        }
        IMOChangeRecord tpMoChangeRecord = context.addDBChangeRecord(Ring.class);
        for (Ring oamRing : tpKeyRefMos) {
            tpMoChangeRecord.addDelete((Object)oamRing);
        }
    }
}

