/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnDeleteRingNodeReq;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnDeleteRingNodeRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.RingMapNode;
import com.huawei.vmf.adapter.fservice.mpls.model.RingSinkNode;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnSPRingTopoInfoTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class DeleteRingNodeTask
extends AbstractConfigQTask<QAsnDeleteRingNodeReq, QAsnDeleteRingNodeRsp> {
    private static final int OAM_MODE_1731 = 2;

    protected DeleteRingNodeTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(MplsRing.class, (ICompositeService)new DefaultCompositeService(MplsRing.class));
    }

    protected void decode(QAsnDeleteRingNodeReq req, Task task, IAsnTranslationContext context) {
        QAsnSPRingTopoInfoTranslator translator = new QAsnSPRingTopoInfoTranslator();
        Collection mos = null;
        try {
            mos = translator.decode((Collection)req.ringNodeKeyList, context);
        }
        catch (VMFException e) {
            this.getLogger().error("DeleteRingNodeTask decode failed!", (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)mos)) {
            return;
        }
        this.deleteRingPath(mos, context);
    }

    private void deleteRingPath(Collection<MplsRing> mos, IAsnTranslationContext context) {
        Context ctx = context.getTransactionContext();
        IMOChangeRecord ringRecord = ctx.addChangeRecord(MplsRing.class);
        IMOChangeRecord nodeRecord = ctx.addChangeRecord(RingMapNode.class);
        ArrayList<RingSinkNode> sinkNodes = new ArrayList<RingSinkNode>();
        HashMap<String, MplsRing> ringMap = new HashMap<String, MplsRing>();
        PropertyChangeItem ringModifyItem = new PropertyChangeItem("ringMapNodes");
        for (MplsRing mo : mos) {
            Collection nodes = mo.getRingMapNodes();
            if (CollectionUtils.isEmpty((Collection)nodes)) continue;
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{mo.getDevID(), mo.getVrID(), mo.getRingId()});
            ringMap.put(key, mo);
            ringRecord.addModify((Object)mo, ringModifyItem);
            for (RingMapNode node : nodes) {
                nodeRecord.cancelModify((Object)node);
                RingSinkNode sinkNode = new RingSinkNode();
                AsnTranslatorUtil.copyDevAndVrId((VmfMO)node, (VmfMO)sinkNode);
                sinkNode.setSinkNodeId(node.getNodeId());
                sinkNode.setRingId(node.getRingId());
                sinkNodes.add(sinkNode);
            }
            nodeRecord.addDelete(nodes);
        }
        try {
            Collection dbSinkNodes = MplsDao.newInstance().queryByKey(RingSinkNode.class, sinkNodes, false);
            if (CollectionUtils.isEmpty((Collection)dbSinkNodes)) {
                return;
            }
            IMOChangeRecord dbSinkNodeRecord = ctx.addDBChangeRecord(RingSinkNode.class);
            for (RingSinkNode sinkeNode : dbSinkNodes) {
                String key = CommonUtil.composeTmpKey((Object[])new Object[]{sinkeNode.getDevID(), sinkeNode.getVrID(), sinkeNode.getRingId()});
                MplsRing ring = (MplsRing)ringMap.get(key);
                if (ring == null) continue;
                ring.addRingSinkNodes(Arrays.asList(sinkeNode));
                ringRecord.addModify((Object)ring, new PropertyChangeItem("ringSinkNodes"));
                dbSinkNodeRecord.addDelete((Object)sinkeNode);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("DeleteRingNodeTask query db RingSinkNode failed!", (Throwable)e);
        }
    }

    protected void encode(QAsnDeleteRingNodeRsp rsp, IAsnTranslationContext context) {
        Context ctx = context.getTransactionContext();
        IMOChangeRecord ringRecord = ctx.addChangeRecord(MplsRing.class);
        QAsnSPRingTopoInfoTranslator translator = new QAsnSPRingTopoInfoTranslator();
        Set mos = ringRecord.getAllChanges();
        rsp.result = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)ringRecord.getAllChanges(), (OperResult)ctx.getOperResult());
        try {
            Collection asns = translator.encode(mos, context);
            rsp.ringNodeList.addAll(asns);
        }
        catch (Exception e) {
            this.getLogger().error("DeleteRingNodeTask encode failed!", (Throwable)e);
        }
    }

    protected Integer getAsnBestEffort(QAsnDeleteRingNodeReq req) {
        return null;
    }

    protected byte[] getAsnTaskFlag(QAsnDeleteRingNodeReq req) {
        return req.strTaskFlag;
    }
}

