/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnProtectionGroupResult;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnDeleteProtectionGroupReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnDeleteProtectionGroupRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.TunnelGroupFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelGroup;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.service.TunnelGroupService;
import java.util.Collection;
import java.util.LinkedList;
import org.slf4j.Logger;

public class DeleteProtectionGroupTask
extends AbstractConfigQTask<QAsnDeleteProtectionGroupReq, QAsnDeleteProtectionGroupRsp> {
    MplsDao dao = MplsDao.newInstance();
    private Logger logger = RunLogger.getLogger(DeleteProtectionGroupTask.class);
    private Collection<TunnelGroup> tunnelGroups;

    public DeleteProtectionGroupTask() {
        super(EOperationType.DELETE);
        this.addMoCompositeService(TunnelGroup.class, (ICompositeService)new TunnelGroupService());
    }

    protected void decode(QAsnDeleteProtectionGroupReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
        TunnelGroupFdnParser fdnParser = new TunnelGroupFdnParser();
        QAsnUniResIDList tunnelGroupKeyList = req.lstProtectionKey;
        LinkedList<TunnelGroup> tunnelGroupKeys = new LinkedList<TunnelGroup>();
        for (QAsnUniResID fdnAsn : tunnelGroupKeyList) {
            TunnelGroup tunnelGroup = (TunnelGroup)fdnParser.getIndexMo(fdnAsn);
            tunnelGroupKeys.add(tunnelGroup);
        }
        try {
            this.tunnelGroups = this.dao.getAllMosByTunnelGroupKeys(tunnelGroupKeys, asnTranslatorContext, EOperationType.DELETE);
        }
        catch (VMFException e) {
            this.logger.error("DeleteProtectionGroupTask decode fail!", (Throwable)e);
            Context context = asnTranslatorContext == null ? new Context() : asnTranslatorContext.getTransactionContext();
            context.addMoOperResults(tunnelGroupKeys, e.getErrorCode());
        }
    }

    protected void encode(QAsnDeleteProtectionGroupRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        rsp.oReturn.result = 0;
        Context context = asnTranslatorContext.getTransactionContext();
        OperResult operResult = context.getOperResult();
        rsp.oReturn = AsnTranslatorUtil.getMosQAsnErrInfoReturn(this.tunnelGroups, (OperResult)operResult);
        TunnelGroupFdnParser fdnParser = new TunnelGroupFdnParser();
        for (TunnelGroup tunnelGroup : this.tunnelGroups) {
            QAsnProtectionGroupResult asnResult = new QAsnProtectionGroupResult();
            asnResult.oProtectionKey = fdnParser.getUniResID((VmfMO)tunnelGroup);
            asnResult.result = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)tunnelGroup, (OperResult)operResult);
            rsp.lstSuccess.add((Object)asnResult);
        }
    }

    protected Integer getAsnBestEffort(QAsnDeleteProtectionGroupReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnDeleteProtectionGroupReq req) {
        return req.strTaskFlag;
    }
}

