/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_spring_model.QAsnSPRingVirtualNode;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnCreateVirtualNodeReq;
import com.huawei.network.qasn.m_q_ip_spring_op.QAsnCreateVirtualNodeRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsRing;
import com.huawei.vmf.adapter.fservice.mpls.model.RingMapVirtualNode;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnSPRingVirtualNodeTranslator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class CreateVirtualNodeTask
extends AbstractConfigQTask<QAsnCreateVirtualNodeReq, QAsnCreateVirtualNodeRsp> {
    private Map<String, String> serialNumMap = new HashMap<String, String>();

    public CreateVirtualNodeTask() {
        super(EOperationType.MODIFY);
        this.addMoCompositeService(MplsRing.class, (ICompositeService)new DefaultCompositeService(MplsRing.class));
    }

    protected void decode(QAsnCreateVirtualNodeReq req, Task task, IAsnTranslationContext context) {
        QAsnSPRingVirtualNodeTranslator translator = new QAsnSPRingVirtualNodeTranslator();
        Collection virtualNodes = null;
        try {
            virtualNodes = translator.decode((Collection)req.virtualNodeList, context);
        }
        catch (VMFException e) {
            this.getLogger().error("CreateVirtualNodeTask decode failed!", (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)virtualNodes)) {
            return;
        }
        Context ctx = context.getTransactionContext();
        IMOChangeRecord ringRecord = ctx.addChangeRecord(MplsRing.class);
        IMOChangeRecord virtualNodeRecord = ctx.addChangeRecord(RingMapVirtualNode.class);
        HashMap<String, MplsRing> ringMap = new HashMap<String, MplsRing>();
        PropertyChangeItem ringModifyItem = new PropertyChangeItem("ringMapVirtualNodes");
        for (RingMapVirtualNode virtualNode : virtualNodes) {
            String key = CommonUtil.composeTmpKey((Object[])new Object[]{virtualNode.getDevID(), virtualNode.getVrID(), virtualNode.getRingId()});
            MplsRing ring = (MplsRing)ringMap.get(key);
            if (ring == null) {
                ring = MplsUtil.translate2Ring(virtualNode);
                ringMap.put(key, ring);
                ringRecord.addModify((Object)ring, ringModifyItem);
            }
            List<RingMapVirtualNode> addNodes = Arrays.asList(virtualNode);
            ring.addRingMapVirtualNodes(addNodes);
            virtualNodeRecord.cancelModify((Object)virtualNode);
            virtualNodeRecord.addCreate(addNodes);
        }
        int len = req.virtualNodeList.size();
        for (int i = 0; i < len; ++i) {
            QAsnSPRingVirtualNode virtualNode = (QAsnSPRingVirtualNode)req.virtualNodeList.get(i);
            StringBuffer key = new StringBuffer();
            key.append(virtualNode.fdn.neID).append("|").append(virtualNode.srcRingID).append("|").append(virtualNode.nodeID);
            this.serialNumMap.put(key.toString(), new String(virtualNode.fdn.poSerialNum));
        }
    }

    protected void encode(QAsnCreateVirtualNodeRsp rsp, IAsnTranslationContext context) {
        QAsnSPRingVirtualNodeTranslator translator = new QAsnSPRingVirtualNodeTranslator();
        Context ctx = context.getTransactionContext();
        IMOChangeRecord ringRecord = ctx.addChangeRecord(MplsRing.class);
        IMOChangeRecord virtualNOdeRecord = ctx.addChangeRecord(RingMapVirtualNode.class);
        OperResult operResult = ctx.getOperResult();
        rsp.result = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)ringRecord.getModifies(), (OperResult)operResult);
        try {
            for (RingMapVirtualNode virtualNode : virtualNOdeRecord.getCreates()) {
                QAsnSPRingVirtualNode asn = (QAsnSPRingVirtualNode)translator.encode(virtualNode, context);
                asn.poResult = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)MplsUtil.translate2Ring(virtualNode), (OperResult)operResult);
                StringBuffer key = new StringBuffer();
                key.append(virtualNode.getDevID()).append("|").append(virtualNode.getRingId()).append("|").append(virtualNode.getVirtualNodeId());
                String serialNm = this.serialNumMap.get(key.toString());
                if (serialNm != null) {
                    asn.fdn.poSerialNum = serialNm.getBytes();
                }
                rsp.virtualNodeList.add((Object)asn);
            }
        }
        catch (VMFException e) {
            this.getLogger().error("CreateVirtualNodeTask encode failed!", (Throwable)e);
            rsp.result.result = e.getErrorCode();
        }
    }

    protected Integer getAsnBestEffort(QAsnCreateVirtualNodeReq req) {
        return null;
    }

    protected byte[] getAsnTaskFlag(QAsnCreateVirtualNodeReq req) {
        return req.strTaskFlag;
    }
}

