/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tpoam_model.QAsnTPOamInfo;
import com.huawei.network.qasn.m_q_ip_tpoam_model.QAsnTPOamResKey;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnLspHop;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnStaticCRTunnelInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyResult;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnCreateStaticCRTnlReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnCreateStaticCRTnlRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractSingleMoConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import com.huawei.vmf.adapter.fservice.tpoam.service.ITpoamService;
import com.huawei.vmf.adapter.mpls.Activator;
import com.huawei.vmf.adapter.mpls.common.MplsUtil;
import com.huawei.vmf.adapter.mpls.service.StaticTunnelService;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnStaticCRTunnelInfoTranslator;
import java.util.Collection;
import java.util.Set;
import net.commustru.fstru.FStruct;

public class CreateStaticCRTnlTask
extends AbstractSingleMoConfigQTask<QAsnCreateStaticCRTnlReq, QAsnCreateStaticCRTnlRsp, QAsnStaticCRTunnelInfo, QAsnStaticCRTunnelInfo, StaticTunnel> {
    protected CreateStaticCRTnlTask() {
        super(StaticTunnel.class, EOperationType.PREDEPLOY, (IAsnTranslator)new QAsnStaticCRTunnelInfoTranslator(), (IAsnTranslator)new QAsnStaticCRTunnelInfoTranslator());
        this.addMoCompositeService(StaticTunnel.class, (ICompositeService)new StaticTunnelService());
    }

    protected void encode(QAsnCreateStaticCRTnlRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Context context = asnTranslatorContext.getTransactionContext();
        IMOChangeRecord tunnelChangeRecord = context.getChangeRecord(this.getMoClazz());
        OperResult operResult = context.getOperResult();
        Set tunnels = tunnelChangeRecord.getAllChanges();
        rsp.oResult = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)tunnels, (OperResult)operResult);
        IFdnParser<StaticTunnel> fdnParser = MplsUtil.getStaticTunnelFdnParser();
        for (StaticTunnel tunnel : tunnels) {
            QAsnTunnelKeyResult resultAsn = new QAsnTunnelKeyResult();
            resultAsn.oTunnelKey = fdnParser.getUniResID((VmfMO)tunnel);
            resultAsn.result = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)tunnel, (OperResult)operResult);
            rsp.lstFail.add((Object)resultAsn);
        }
    }

    protected Integer getAsnBestEffort(QAsnCreateStaticCRTnlReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnCreateStaticCRTnlReq req) {
        return req.strTaskFlag;
    }

    protected Collection<QAsnStaticCRTunnelInfo> getDecodeAsns(QAsnCreateStaticCRTnlReq req) {
        return req.lstStaticCRTunnelInfo;
    }

    protected void setEncodeAsns(Collection<QAsnStaticCRTunnelInfo> encodeAsns, QAsnCreateStaticCRTnlRsp rsp, IAsnTranslationContext context) {
    }

    protected void executeTask(QAsnCreateStaticCRTnlReq req, QAsnCreateStaticCRTnlRsp rsp, Task task) {
        super.executeTask((FStruct)req, (FStruct)rsp, task);
        ITpoamService tpOamService = Activator.getService(ITpoamService.class);
        int len = req.lstStaticCRTunnelInfo.size();
        for (int i = 0; i < len; ++i) {
            QAsnStaticCRTunnelInfo tunnelInfo = (QAsnStaticCRTunnelInfo)req.lstStaticCRTunnelInfo.get(i);
            int length = tunnelInfo.lstLspHop.size();
            for (int j = 0; j < length; ++j) {
                QAsnLspHop lspHop = (QAsnLspHop)tunnelInfo.lstLspHop.get(j);
                if (null == lspHop.poTPOam) continue;
                QAsnTPOamInfo tpOamInfo = new QAsnTPOamInfo();
                tpOamInfo.iDeployStatus = 0;
                StaticTunnel staticTunnel = new StaticTunnel();
                MplsUtil.getStaticTunnelFromAsn(tunnelInfo.oTunnelBase, staticTunnel);
                String fdn = MplsUtil.getTunnelFdn((VmfMO)staticTunnel);
                tpOamInfo.oKey = new QAsnTPOamResKey();
                tpOamInfo.oKey.iSeviceType = 2;
                tpOamInfo.oKey.oResKey = tunnelInfo.oTunnelBase.oTunnelKey;
                tpOamInfo.oKey.oResKey.strFDN = fdn.getBytes();
                tpOamInfo.oMeg = lspHop.poTPOam;
                try {
                    tpOamService.createTPOAM(tpOamInfo);
                    continue;
                }
                catch (VMFException e) {
                    this.getLogger().error("CreateStaticCRTnlTask tpOamService.createTPOAM failed!");
                }
            }
        }
    }
}

