/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelPGInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelPGInfoList;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnCreateProtectionGroupReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnCreateProtectionGroupRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelGroup;
import com.huawei.vmf.adapter.mpls.service.TunnelGroupService;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelPGInfoTranslator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class CreateProtectionGroupTask
extends AbstractConfigQTask<QAsnCreateProtectionGroupReq, QAsnCreateProtectionGroupRsp> {
    private Logger logger = RunLogger.getLogger(CreateProtectionGroupTask.class);
    private Map<TunnelGroup, QAsnTunnelPGInfo> tpgInfoAsnMap = new HashMap<TunnelGroup, QAsnTunnelPGInfo>();

    protected CreateProtectionGroupTask() {
        super(EOperationType.PREDEPLOY);
        this.addMoCompositeService(TunnelGroup.class, (ICompositeService)new TunnelGroupService());
    }

    protected void decode(QAsnCreateProtectionGroupReq req, Task task, IAsnTranslationContext context) {
        QAsnTunnelPGInfoList decodeAsns = req.lstProtectionGroupInfo;
        try {
            for (QAsnTunnelPGInfo decodeAsn : decodeAsns) {
                TunnelGroup tunnelMO = new TunnelGroup();
                QAsnTunnelPGInfoTranslator translator = new QAsnTunnelPGInfoTranslator();
                translator.decode(decodeAsn, tunnelMO, context);
                this.tpgInfoAsnMap.put(tunnelMO, decodeAsn);
            }
        }
        catch (VMFException e) {
            this.logger.error("decode req error. decodeAsns=" + decodeAsns, (Throwable)e);
        }
    }

    protected void encode(QAsnCreateProtectionGroupRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Context context = asnTranslatorContext.getTransactionContext();
        IMOChangeRecord tunnelGPChangeRecord = context.getChangeRecord(TunnelGroup.class);
        OperResult operResult = context.getOperResult();
        Set tunnelGPs = tunnelGPChangeRecord.getCreates();
        rsp.oReturn = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)tunnelGPs, (OperResult)operResult);
        for (TunnelGroup tunnelGP : tunnelGPs) {
            QAsnTunnelPGInfo asnTunnelPGInfo = this.tpgInfoAsnMap.get(tunnelGP);
            asnTunnelPGInfo.poDeployStatus = tunnelGP.getDeployStatus();
            asnTunnelPGInfo.poOperResult = AsnTranslatorUtil.getMoQAsnErrInfo((VmfMO)tunnelGP, (OperResult)operResult);
            rsp.lstProtectionGroupInfo.add((Object)asnTunnelPGInfo);
        }
    }

    protected Integer getAsnBestEffort(QAsnCreateProtectionGroupReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnCreateProtectionGroupReq req) {
        return req.strTaskFlag;
    }
}

