/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnPwOamAttr;
import com.huawei.network.qasn.m_q_ip_pwe3_model.QAsnPwe3ModifyPwOam;
import com.huawei.network.qasn.m_q_ip_pwe3_op.QAsnModifyPwOamReq;
import com.huawei.network.qasn.m_q_ip_pwe3_op.QAsnModifyPwOamRsp;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelOAMInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamPw;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnPwOamAttrTranslator;
import java.util.Collection;
import java.util.Set;

public class ConfigOamPwInfoForModifyDBTask
extends AbstractConfigQTask<QAsnModifyPwOamReq, QAsnModifyPwOamRsp> {
    private QAsnPwOamAttr qasnPwOAMInfo;
    private String fdn;

    protected ConfigOamPwInfoForModifyDBTask(QAsnPwOamAttr qasnPwOAMInfo, String fdn) {
        super(EOperationType.MODIFY);
        this.qasnPwOAMInfo = qasnPwOAMInfo;
        this.fdn = fdn;
    }

    protected void decode(QAsnModifyPwOamReq req, Task task, IAsnTranslationContext context) {
        int len = req.pwOamInfoList.size();
        for (int i = 0; i < len; ++i) {
            QAsnPwOamAttr decodeAsn = ((QAsnPwe3ModifyPwOam)req.pwOamInfoList.get((int)i)).newPwOamAttr;
            try {
                MplsOamPw mo = new MplsOamPw();
                QAsnPwOamAttrTranslator translator = new QAsnPwOamAttrTranslator(this.fdn);
                translator.decode(decodeAsn, mo, context);
                continue;
            }
            catch (VMFException e) {
                this.getLogger().error("decode req error. decodeAsns=" + decodeAsn, (Throwable)e);
            }
        }
    }

    protected void encode(QAsnModifyPwOamRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Context context = asnTranslatorContext.getTransactionContext();
        IMOChangeRecord tunnelChangeRecord = context.getChangeRecord(MplsOamPw.class);
        OperResult operResult = context.getOperResult();
        Set pws = tunnelChangeRecord.getAllChanges();
        rsp.result = AsnTranslatorUtil.getMosQAsnErrInfoReturn((Collection)pws, (OperResult)operResult);
    }

    protected void executeTask(QAsnModifyPwOamReq req, QAsnModifyPwOamRsp rsp, Task task) {
        IAsnTranslationContext asnTranslatorContext = this.getContext(req);
        this.decode(req, task, asnTranslatorContext);
        try {
            Context ctx = asnTranslatorContext.getTransactionContext();
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(ctx);
            dao.merge(MplsOamPw.class, false);
        }
        catch (VMFException e) {
            this.getLogger().error("ConfigOamInfoForModifyDBTask error. ", (Throwable)e);
        }
        this.encode(rsp, asnTranslatorContext);
    }

    protected Integer getAsnBestEffort(QAsnModifyPwOamReq req) {
        return 1;
    }

    protected byte[] getAsnTaskFlag(QAsnModifyPwOamReq req) {
        return req.poTaskFlag;
    }

    protected Collection<QAsnPwOamAttr> getDecodeAsns(QAsnModifyPwOamReq req) {
        return null;
    }

    protected void setEncodeAsns(Collection<QAsnTunnelOAMInfo> encodeAsns, QAsnModifyPwOamRsp rsp, IAsnTranslationContext context) {
    }

    private IAsnTranslationContext getContext(QAsnModifyPwOamReq req) {
        AsnTranslationContext asnTranslationContext = new AsnTranslationContext();
        asnTranslationContext.setOperType(this.getOperType());
        Context context = new Context();
        asnTranslationContext.setTransactionContext(context);
        Integer bestEffort = this.getAsnBestEffort(req);
        if (null != bestEffort && bestEffort.equals(1)) {
            context.setBestEffort(true);
        }
        context.setTaskFlag(StringUtil.globalString((byte[])this.getAsnTaskFlag(req)));
        return asnTranslationContext;
    }
}

