/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.mpls.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelKeyResult;
import com.huawei.network.qasn.m_q_ip_tunnel_model.QAsnTunnelOAMInfo;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnConfigOAMInfoReq;
import com.huawei.network.qasn.m_q_ip_tunnel_op.QAsnConfigOAMInfoRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractSingleMoConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.fdn.StaticTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.mpls.dao.MplsDao;
import com.huawei.vmf.adapter.mpls.translation.asn.QAsnTunnelOAMInfoTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class ConfigOamInfoForModifyTask
extends AbstractSingleMoConfigQTask<QAsnConfigOAMInfoReq, QAsnConfigOAMInfoRsp, QAsnTunnelOAMInfo, QAsnTunnelOAMInfo, MplsOamTunnel> {
    private QAsnTunnelOAMInfo qasnTunnelOAMInfo;

    protected ConfigOamInfoForModifyTask(QAsnTunnelOAMInfo qasnTunnelOAMInfo) {
        super(MplsOamTunnel.class, EOperationType.MODIFY, (IAsnTranslator)new QAsnTunnelOAMInfoTranslator(), (IAsnTranslator)new QAsnTunnelOAMInfoTranslator());
        this.qasnTunnelOAMInfo = qasnTunnelOAMInfo;
    }

    protected void decode(QAsnConfigOAMInfoReq req, Task task, IAsnTranslationContext context) {
        QAsnTunnelOAMInfo decodeAsn = this.qasnTunnelOAMInfo;
        try {
            MplsOamTunnel mo = new MplsOamTunnel();
            QAsnTunnelOAMInfoTranslator translator = new QAsnTunnelOAMInfoTranslator();
            translator.decode(decodeAsn, mo, context);
        }
        catch (VMFException e) {
            this.getLogger().error("decode req error. decodeAsns=" + decodeAsn, (Throwable)e);
        }
    }

    protected void encode(QAsnConfigOAMInfoRsp rsp, IAsnTranslationContext asnTranslatorContext) {
        Context context = asnTranslatorContext.getTransactionContext();
        IMOChangeRecord tunnelChangeRecord = context.getChangeRecord(this.getMoClazz());
        OperResult operResult = context.getOperResult();
        Set tunnels = tunnelChangeRecord.getAllChanges();
        StaticTunnelFdnParser fdnParser = new StaticTunnelFdnParser();
        ArrayList<StaticTunnel> staticTunnels = new ArrayList<StaticTunnel>();
        for (MplsOamTunnel tunnel : tunnels) {
            StaticTunnel staticTunnel = new StaticTunnel();
            staticTunnel.setDevID(tunnel.getDevID());
            staticTunnel.setVrID(tunnel.getVrID());
            staticTunnel.setTunnelName(tunnel.getTunnelName());
            staticTunnels.add(staticTunnel);
        }
        Collection staticTunnelFromDB = null;
        try {
            staticTunnelFromDB = MplsDao.newInstance().queryByKey(StaticTunnel.class, staticTunnels, false);
        }
        catch (VMFException e) {
            this.getLogger().error("ConfigOamInfoForModifyTask get StaticTunnel info error");
        }
        for (MplsOamTunnel tunnel : tunnels) {
            QAsnTunnelKeyResult result = new QAsnTunnelKeyResult();
            ErrorInfo error = AsnTranslatorUtil.getMoWithRefOperResult((VmfMO)tunnel, (OperResult)operResult);
            if (!this.isSuccess(error)) {
                result.result.errCode = error.getErrorCode();
                result.result.strOperDesc = StringUtil.globalByte((String)error.getErrorMessage());
            } else {
                result.result.errCode = 0;
            }
            for (StaticTunnel staticTunnel : staticTunnelFromDB) {
                if (tunnel.getDevID().intValue() != staticTunnel.getDevID().intValue() || tunnel.getVrID().intValue() != staticTunnel.getVrID().intValue() || !tunnel.getTunnelName().equals(staticTunnel.getTunnelName())) continue;
                result.oTunnelKey = fdnParser.getUniResID((VmfMO)staticTunnel);
                break;
            }
            rsp.lstOAMKeySuccess.add((Object)result);
        }
        rsp.oResult.result = AsnTranslatorUtil.getMosResultCode((Collection)tunnels, (OperResult)operResult);
    }

    protected Integer getAsnBestEffort(QAsnConfigOAMInfoReq req) {
        return req.bestEffort;
    }

    protected byte[] getAsnTaskFlag(QAsnConfigOAMInfoReq req) {
        return req.strTaskFlag;
    }

    protected Collection<QAsnTunnelOAMInfo> getDecodeAsns(QAsnConfigOAMInfoReq req) {
        return null;
    }

    protected void setEncodeAsns(Collection<QAsnTunnelOAMInfo> encodeAsns, QAsnConfigOAMInfoRsp rsp, IAsnTranslationContext context) {
    }
}

